// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Contains settings used by Amazon Lex to select a slot value.
 */
class SlotValueSelectionSetting private constructor(builder: Builder) {
    /**
     * Provides settings that enable advanced recognition settings for slot values.
     */
    val advancedRecognitionSetting: aws.sdk.kotlin.services.lexmodelsv2.model.AdvancedRecognitionSetting? = builder.advancedRecognitionSetting
    /**
     * A regular expression used to validate the value of a slot.
     */
    val regexFilter: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueRegexFilter? = builder.regexFilter
    /**
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:
     * + OriginalValue - Returns the value entered by the user, if the user value is similar to the slot value.
     * + TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.
     *
     * If you don't specify the valueSelectionStrategy, the default is OriginalValue.
     */
    val resolutionStrategy: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueResolutionStrategy? = builder.resolutionStrategy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SlotValueSelectionSetting(")
        append("advancedRecognitionSetting=$advancedRecognitionSetting,")
        append("regexFilter=$regexFilter,")
        append("resolutionStrategy=$resolutionStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedRecognitionSetting?.hashCode() ?: 0
        result = 31 * result + (regexFilter?.hashCode() ?: 0)
        result = 31 * result + (resolutionStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SlotValueSelectionSetting

        if (advancedRecognitionSetting != other.advancedRecognitionSetting) return false
        if (regexFilter != other.regexFilter) return false
        if (resolutionStrategy != other.resolutionStrategy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides settings that enable advanced recognition settings for slot values.
         */
        var advancedRecognitionSetting: aws.sdk.kotlin.services.lexmodelsv2.model.AdvancedRecognitionSetting? = null
        /**
         * A regular expression used to validate the value of a slot.
         */
        var regexFilter: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueRegexFilter? = null
        /**
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:
         * + OriginalValue - Returns the value entered by the user, if the user value is similar to the slot value.
         * + TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.
         *
         * If you don't specify the valueSelectionStrategy, the default is OriginalValue.
         */
        var resolutionStrategy: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueResolutionStrategy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting) : this() {
            this.advancedRecognitionSetting = x.advancedRecognitionSetting
            this.regexFilter = x.regexFilter
            this.resolutionStrategy = x.resolutionStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting = SlotValueSelectionSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.AdvancedRecognitionSetting] inside the given [block]
         */
        fun advancedRecognitionSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.AdvancedRecognitionSetting.Builder.() -> kotlin.Unit) {
            this.advancedRecognitionSetting = aws.sdk.kotlin.services.lexmodelsv2.model.AdvancedRecognitionSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueRegexFilter] inside the given [block]
         */
        fun regexFilter(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueRegexFilter.Builder.() -> kotlin.Unit) {
            this.regexFilter = aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueRegexFilter.invoke(block)
        }
    }
}
