// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Settings that you can use for eliciting a slot value.
 */
class SlotValueElicitationSetting private constructor(builder: Builder) {
    /**
     * A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
     */
    val defaultValueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification? = builder.defaultValueSpecification
    /**
     * The prompt that Amazon Lex uses to elicit the slot value from the user.
     */
    val promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = builder.promptSpecification
    /**
     * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of understanding user utterances.
     */
    val sampleUtterances: List<SampleUtterance>? = builder.sampleUtterances
    /**
     * Specifies whether the slot is required or optional.
     */
    val slotConstraint: aws.sdk.kotlin.services.lexmodelsv2.model.SlotConstraint? = builder.slotConstraint
    /**
     * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
     */
    val waitAndContinueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification? = builder.waitAndContinueSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SlotValueElicitationSetting(")
        append("defaultValueSpecification=$defaultValueSpecification,")
        append("promptSpecification=$promptSpecification,")
        append("sampleUtterances=$sampleUtterances,")
        append("slotConstraint=$slotConstraint,")
        append("waitAndContinueSpecification=$waitAndContinueSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValueSpecification?.hashCode() ?: 0
        result = 31 * result + (promptSpecification?.hashCode() ?: 0)
        result = 31 * result + (sampleUtterances?.hashCode() ?: 0)
        result = 31 * result + (slotConstraint?.hashCode() ?: 0)
        result = 31 * result + (waitAndContinueSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SlotValueElicitationSetting

        if (defaultValueSpecification != other.defaultValueSpecification) return false
        if (promptSpecification != other.promptSpecification) return false
        if (sampleUtterances != other.sampleUtterances) return false
        if (slotConstraint != other.slotConstraint) return false
        if (waitAndContinueSpecification != other.waitAndContinueSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
         */
        var defaultValueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification? = null
        /**
         * The prompt that Amazon Lex uses to elicit the slot value from the user.
         */
        var promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = null
        /**
         * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of understanding user utterances.
         */
        var sampleUtterances: List<SampleUtterance>? = null
        /**
         * Specifies whether the slot is required or optional.
         */
        var slotConstraint: aws.sdk.kotlin.services.lexmodelsv2.model.SlotConstraint? = null
        /**
         * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
         */
        var waitAndContinueSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting) : this() {
            this.defaultValueSpecification = x.defaultValueSpecification
            this.promptSpecification = x.promptSpecification
            this.sampleUtterances = x.sampleUtterances
            this.slotConstraint = x.slotConstraint
            this.waitAndContinueSpecification = x.waitAndContinueSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting = SlotValueElicitationSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification] inside the given [block]
         */
        fun defaultValueSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification.Builder.() -> kotlin.Unit) {
            this.defaultValueSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.SlotDefaultValueSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification] inside the given [block]
         */
        fun promptSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.Builder.() -> kotlin.Unit) {
            this.promptSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification] inside the given [block]
         */
        fun waitAndContinueSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification.Builder.() -> kotlin.Unit) {
            this.waitAndContinueSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification.invoke(block)
        }
    }
}
