// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a slot type.
 */
class SlotTypeSummary private constructor(builder: Builder) {
    /**
     * The description of the slot type.
     */
    val description: kotlin.String? = builder.description
    /**
     * A timestamp of the date and time that the slot type was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * If the slot type is derived from a built-on slot type, the name of the parent slot type.
     */
    val parentSlotTypeSignature: kotlin.String? = builder.parentSlotTypeSignature
    /**
     * Indicates the type of the slot type.
     * + `Custom` - A slot type that you created using custom values. For more information, see [Creating custom slot types](https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html).
     * + `Extended` - A slot type created by extending the AMAZON.AlphaNumeric built-in slot type. For more information, see [AMAZON.AlphaNumeric](https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html).
     * + `ExternalGrammar` - A slot type using a custom GRXML grammar to define values. For more information, see [Using a custom grammar slot type](https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html).
     */
    val slotTypeCategory: aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeCategory? = builder.slotTypeCategory
    /**
     * The unique identifier assigned to the slot type.
     */
    val slotTypeId: kotlin.String? = builder.slotTypeId
    /**
     * The name of the slot type.
     */
    val slotTypeName: kotlin.String? = builder.slotTypeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SlotTypeSummary(")
        append("description=$description,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("parentSlotTypeSignature=$parentSlotTypeSignature,")
        append("slotTypeCategory=$slotTypeCategory,")
        append("slotTypeId=$slotTypeId,")
        append("slotTypeName=$slotTypeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (parentSlotTypeSignature?.hashCode() ?: 0)
        result = 31 * result + (slotTypeCategory?.hashCode() ?: 0)
        result = 31 * result + (slotTypeId?.hashCode() ?: 0)
        result = 31 * result + (slotTypeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SlotTypeSummary

        if (description != other.description) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (parentSlotTypeSignature != other.parentSlotTypeSignature) return false
        if (slotTypeCategory != other.slotTypeCategory) return false
        if (slotTypeId != other.slotTypeId) return false
        if (slotTypeName != other.slotTypeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the slot type.
         */
        var description: kotlin.String? = null
        /**
         * A timestamp of the date and time that the slot type was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the slot type is derived from a built-on slot type, the name of the parent slot type.
         */
        var parentSlotTypeSignature: kotlin.String? = null
        /**
         * Indicates the type of the slot type.
         * + `Custom` - A slot type that you created using custom values. For more information, see [Creating custom slot types](https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html).
         * + `Extended` - A slot type created by extending the AMAZON.AlphaNumeric built-in slot type. For more information, see [AMAZON.AlphaNumeric](https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html).
         * + `ExternalGrammar` - A slot type using a custom GRXML grammar to define values. For more information, see [Using a custom grammar slot type](https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html).
         */
        var slotTypeCategory: aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeCategory? = null
        /**
         * The unique identifier assigned to the slot type.
         */
        var slotTypeId: kotlin.String? = null
        /**
         * The name of the slot type.
         */
        var slotTypeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSummary) : this() {
            this.description = x.description
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.parentSlotTypeSignature = x.parentSlotTypeSignature
            this.slotTypeCategory = x.slotTypeCategory
            this.slotTypeId = x.slotTypeId
            this.slotTypeName = x.slotTypeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSummary = SlotTypeSummary(this)
    }
}
