// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
 */
class S3BucketTranscriptSource private constructor(builder: Builder) {
    /**
     * The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is encrypted using a customer managed KMS key.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.
     */
    val pathFormat: aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat? = builder.pathFormat
    /**
     * The name of the bucket containing the transcript and the associated metadata.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you provide.
     */
    val transcriptFilter: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter? = builder.transcriptFilter
    /**
     * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
     */
    val transcriptFormat: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFormat? = builder.transcriptFormat

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketTranscriptSource(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("pathFormat=$pathFormat,")
        append("s3BucketName=$s3BucketName,")
        append("transcriptFilter=$transcriptFilter,")
        append("transcriptFormat=$transcriptFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (pathFormat?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (transcriptFilter?.hashCode() ?: 0)
        result = 31 * result + (transcriptFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketTranscriptSource

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (pathFormat != other.pathFormat) return false
        if (s3BucketName != other.s3BucketName) return false
        if (transcriptFilter != other.transcriptFilter) return false
        if (transcriptFormat != other.transcriptFormat) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket. Only use this field if your bucket is encrypted using a customer managed KMS key.
         */
        var kmsKeyArn: kotlin.String? = null
        /**
         * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.
         */
        var pathFormat: aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat? = null
        /**
         * The name of the bucket containing the transcript and the associated metadata.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * The object that contains the filter which will be applied when Amazon Lex reads through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read only a subset of the Amazon S3 bucket based on the filter you provide.
         */
        var transcriptFilter: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter? = null
        /**
         * The format of the transcript content. Currently, Genie only supports the Amazon Lex transcript format.
         */
        var transcriptFormat: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFormat? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.pathFormat = x.pathFormat
            this.s3BucketName = x.s3BucketName
            this.transcriptFilter = x.transcriptFilter
            this.transcriptFormat = x.transcriptFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketTranscriptSource = S3BucketTranscriptSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat] inside the given [block]
         */
        fun pathFormat(block: aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat.Builder.() -> kotlin.Unit) {
            this.pathFormat = aws.sdk.kotlin.services.lexmodelsv2.model.PathFormat.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter] inside the given [block]
         */
        fun transcriptFilter(block: aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter.Builder.() -> kotlin.Unit) {
            this.transcriptFilter = aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptFilter.invoke(block)
        }
    }
}
