// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
 */
class PromptSpecification private constructor(builder: Builder) {
    /**
     * Indicates whether the user can interrupt a speech prompt from the bot.
     */
    val allowInterrupt: kotlin.Boolean? = builder.allowInterrupt
    /**
     * The maximum number of times the bot tries to elicit a response from the user using this prompt.
     */
    val maxRetries: kotlin.Int? = builder.maxRetries
    /**
     * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime.
     */
    val messageGroups: List<MessageGroup>? = builder.messageGroups

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PromptSpecification(")
        append("allowInterrupt=$allowInterrupt,")
        append("maxRetries=$maxRetries,")
        append("messageGroups=$messageGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowInterrupt?.hashCode() ?: 0
        result = 31 * result + (maxRetries ?: 0)
        result = 31 * result + (messageGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PromptSpecification

        if (allowInterrupt != other.allowInterrupt) return false
        if (maxRetries != other.maxRetries) return false
        if (messageGroups != other.messageGroups) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the user can interrupt a speech prompt from the bot.
         */
        var allowInterrupt: kotlin.Boolean? = null
        /**
         * The maximum number of times the bot tries to elicit a response from the user using this prompt.
         */
        var maxRetries: kotlin.Int? = null
        /**
         * A collection of messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime.
         */
        var messageGroups: List<MessageGroup>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification) : this() {
            this.allowInterrupt = x.allowInterrupt
            this.maxRetries = x.maxRetries
            this.messageGroups = x.messageGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification = PromptSpecification(this)
    }
}
