// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



class ListSlotTypesRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the bot that contains the slot types.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot that contains the slot type.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.
     */
    val filters: List<SlotTypeFilter>? = builder.filters
    /**
     * The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the response from the `ListSlotTypes` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response. Use that token in the `nextToken` parameter to return the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Determines the sort order for the response from the `ListSlotTypes` operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.
     */
    val sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSortBy? = builder.sortBy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotTypesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSlotTypesRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("filters=$filters,")
        append("localeId=$localeId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSlotTypesRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (filters != other.filters) return false
        if (localeId != other.localeId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotTypesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the bot that contains the slot types.
         */
        var botId: kotlin.String? = null
        /**
         * The version of the bot that contains the slot type.
         */
        var botVersion: kotlin.String? = null
        /**
         * Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.
         */
        var filters: List<SlotTypeFilter>? = null
        /**
         * The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        var localeId: kotlin.String? = null
        /**
         * The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
         */
        var maxResults: kotlin.Int? = null
        /**
         * If the response from the `ListSlotTypes` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response. Use that token in the `nextToken` parameter to return the next page of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * Determines the sort order for the response from the `ListSlotTypes` operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.
         */
        var sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSortBy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotTypesRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.filters = x.filters
            this.localeId = x.localeId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.ListSlotTypesRequest = ListSlotTypesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSortBy] inside the given [block]
         */
        fun sortBy(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSortBy.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeSortBy.invoke(block)
        }
    }
}
