// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



class ListImportsRequest private constructor(builder: Builder) {
    /**
     * The unique identifier that Amazon Lex assigned to the bot.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot to list imports for.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.
     */
    val filters: List<ImportFilter>? = builder.filters
    /**
     * Specifies the locale that should be present in the list. If you don't specify a resource type in the `filters` parameter, the list contains both bot locales and custom vocabularies.
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the response from the `ListImports` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response.
     *
     * Use the returned token in the `nextToken` parameter of a `ListImports` request to return the next page of results. For a complete set of results, call the `ListImports` operation until the `nextToken` returned in the response is null.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Determines the field that the list of imports is sorted by. You can sort by the `LastUpdatedDateTime` field in ascending or descending order.
     */
    val sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.ImportSortBy? = builder.sortBy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.ListImportsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListImportsRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("filters=$filters,")
        append("localeId=$localeId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListImportsRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (filters != other.filters) return false
        if (localeId != other.localeId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.ListImportsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier that Amazon Lex assigned to the bot.
         */
        var botId: kotlin.String? = null
        /**
         * The version of the bot to list imports for.
         */
        var botVersion: kotlin.String? = null
        /**
         * Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.
         */
        var filters: List<ImportFilter>? = null
        /**
         * Specifies the locale that should be present in the list. If you don't specify a resource type in the `filters` parameter, the list contains both bot locales and custom vocabularies.
         */
        var localeId: kotlin.String? = null
        /**
         * The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
         */
        var maxResults: kotlin.Int? = null
        /**
         * If the response from the `ListImports` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response.
         *
         * Use the returned token in the `nextToken` parameter of a `ListImports` request to return the next page of results. For a complete set of results, call the `ListImports` operation until the `nextToken` returned in the response is null.
         */
        var nextToken: kotlin.String? = null
        /**
         * Determines the field that the list of imports is sorted by. You can sort by the `LastUpdatedDateTime` field in ascending or descending order.
         */
        var sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.ImportSortBy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.ListImportsRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.filters = x.filters
            this.localeId = x.localeId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.ListImportsRequest = ListImportsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ImportSortBy] inside the given [block]
         */
        fun sortBy(block: aws.sdk.kotlin.services.lexmodelsv2.model.ImportSortBy.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.lexmodelsv2.model.ImportSortBy.invoke(block)
        }
    }
}
