// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



class ListBuiltInIntentsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the response from the `ListBuiltInIntents` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response. Use that token in the `nextToken` parameter to return the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.
     */
    val sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.BuiltInIntentSortBy? = builder.sortBy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInIntentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBuiltInIntentsRequest(")
        append("localeId=$localeId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = localeId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBuiltInIntentsRequest

        if (localeId != other.localeId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInIntentsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        var localeId: kotlin.String? = null
        /**
         * The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.
         */
        var maxResults: kotlin.Int? = null
        /**
         * If the response from the `ListBuiltInIntents` operation contains more results than specified in the `maxResults` parameter, a token is returned in the response. Use that token in the `nextToken` parameter to return the next page of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.
         */
        var sortBy: aws.sdk.kotlin.services.lexmodelsv2.model.BuiltInIntentSortBy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInIntentsRequest) : this() {
            this.localeId = x.localeId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.ListBuiltInIntentsRequest = ListBuiltInIntentsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.BuiltInIntentSortBy] inside the given [block]
         */
        fun sortBy(block: aws.sdk.kotlin.services.lexmodelsv2.model.BuiltInIntentSortBy.Builder.() -> kotlin.Unit) {
            this.sortBy = aws.sdk.kotlin.services.lexmodelsv2.model.BuiltInIntentSortBy.invoke(block)
        }
    }
}
