// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about an intent returned by the `ListIntents` operation.
 */
class IntentSummary private constructor(builder: Builder) {
    /**
     * The description of the intent.
     */
    val description: kotlin.String? = builder.description
    /**
     * The input contexts that must be active for this intent to be considered for recognition.
     */
    val inputContexts: List<InputContext>? = builder.inputContexts
    /**
     * The unique identifier assigned to the intent. Use this ID to get detailed information about the intent with the `DescribeIntent` operation.
     */
    val intentId: kotlin.String? = builder.intentId
    /**
     * The name of the intent.
     */
    val intentName: kotlin.String? = builder.intentName
    /**
     * The timestamp of the date and time that the intent was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The output contexts that are activated when this intent is fulfilled.
     */
    val outputContexts: List<OutputContext>? = builder.outputContexts
    /**
     * If this intent is derived from a built-in intent, the name of the parent intent.
     */
    val parentIntentSignature: kotlin.String? = builder.parentIntentSignature

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.IntentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntentSummary(")
        append("description=$description,")
        append("inputContexts=$inputContexts,")
        append("intentId=$intentId,")
        append("intentName=$intentName,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("outputContexts=$outputContexts,")
        append("parentIntentSignature=$parentIntentSignature)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (inputContexts?.hashCode() ?: 0)
        result = 31 * result + (intentId?.hashCode() ?: 0)
        result = 31 * result + (intentName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (outputContexts?.hashCode() ?: 0)
        result = 31 * result + (parentIntentSignature?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntentSummary

        if (description != other.description) return false
        if (inputContexts != other.inputContexts) return false
        if (intentId != other.intentId) return false
        if (intentName != other.intentName) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (outputContexts != other.outputContexts) return false
        if (parentIntentSignature != other.parentIntentSignature) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.IntentSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the intent.
         */
        var description: kotlin.String? = null
        /**
         * The input contexts that must be active for this intent to be considered for recognition.
         */
        var inputContexts: List<InputContext>? = null
        /**
         * The unique identifier assigned to the intent. Use this ID to get detailed information about the intent with the `DescribeIntent` operation.
         */
        var intentId: kotlin.String? = null
        /**
         * The name of the intent.
         */
        var intentName: kotlin.String? = null
        /**
         * The timestamp of the date and time that the intent was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The output contexts that are activated when this intent is fulfilled.
         */
        var outputContexts: List<OutputContext>? = null
        /**
         * If this intent is derived from a built-in intent, the name of the parent intent.
         */
        var parentIntentSignature: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.IntentSummary) : this() {
            this.description = x.description
            this.inputContexts = x.inputContexts
            this.intentId = x.intentId
            this.intentName = x.intentName
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.outputContexts = x.outputContexts
            this.parentIntentSignature = x.parentIntentSignature
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.IntentSummary = IntentSummary(this)
    }
}
