// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Provides a prompt for making sure that the user is ready for the intent to be fulfilled.
 */
class IntentConfirmationSetting private constructor(builder: Builder) {
    /**
     * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the `active` field isn't specified, the default is true.
     */
    val active: kotlin.Boolean? = builder.active
    /**
     * When the user answers "no" to the question defined in `promptSpecification`, Amazon Lex responds with this response to acknowledge that the intent was canceled.
     */
    val declinationResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.declinationResponse
    /**
     * Prompts the user to confirm the intent. This question should have a yes or no answer.
     *
     * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the `OrderPizza` intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
     */
    val promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = builder.promptSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntentConfirmationSetting(")
        append("active=$active,")
        append("declinationResponse=$declinationResponse,")
        append("promptSpecification=$promptSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (declinationResponse?.hashCode() ?: 0)
        result = 31 * result + (promptSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntentConfirmationSetting

        if (active != other.active) return false
        if (declinationResponse != other.declinationResponse) return false
        if (promptSpecification != other.promptSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the `active` field isn't specified, the default is true.
         */
        var active: kotlin.Boolean? = null
        /**
         * When the user answers "no" to the question defined in `promptSpecification`, Amazon Lex responds with this response to acknowledge that the intent was canceled.
         */
        var declinationResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         *
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the `OrderPizza` intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
         */
        var promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting) : this() {
            this.active = x.active
            this.declinationResponse = x.declinationResponse
            this.promptSpecification = x.promptSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting = IntentConfirmationSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        fun declinationResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.declinationResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification] inside the given [block]
         */
        fun promptSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.Builder.() -> kotlin.Unit) {
            this.promptSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.invoke(block)
        }
    }
}
