// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Determines if a Lambda function should be invoked for a specific intent.
 */
class FulfillmentCodeHookSettings private constructor(builder: Builder) {
    /**
     * Indicates whether a Lambda function should be invoked to fulfill a specific intent.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations.
     */
    val fulfillmentUpdatesSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification? = builder.fulfillmentUpdatesSpecification
    /**
     * Provides settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
     */
    val postFulfillmentStatusSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PostFulfillmentStatusSpecification? = builder.postFulfillmentStatusSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FulfillmentCodeHookSettings(")
        append("enabled=$enabled,")
        append("fulfillmentUpdatesSpecification=$fulfillmentUpdatesSpecification,")
        append("postFulfillmentStatusSpecification=$postFulfillmentStatusSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (fulfillmentUpdatesSpecification?.hashCode() ?: 0)
        result = 31 * result + (postFulfillmentStatusSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FulfillmentCodeHookSettings

        if (enabled != other.enabled) return false
        if (fulfillmentUpdatesSpecification != other.fulfillmentUpdatesSpecification) return false
        if (postFulfillmentStatusSpecification != other.postFulfillmentStatusSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether a Lambda function should be invoked to fulfill a specific intent.
         */
        var enabled: kotlin.Boolean = false
        /**
         * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations.
         */
        var fulfillmentUpdatesSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification? = null
        /**
         * Provides settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
         */
        var postFulfillmentStatusSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PostFulfillmentStatusSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings) : this() {
            this.enabled = x.enabled
            this.fulfillmentUpdatesSpecification = x.fulfillmentUpdatesSpecification
            this.postFulfillmentStatusSpecification = x.postFulfillmentStatusSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings = FulfillmentCodeHookSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification] inside the given [block]
         */
        fun fulfillmentUpdatesSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification.Builder.() -> kotlin.Unit) {
            this.fulfillmentUpdatesSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdatesSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PostFulfillmentStatusSpecification] inside the given [block]
         */
        fun postFulfillmentStatusSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.PostFulfillmentStatusSpecification.Builder.() -> kotlin.Unit) {
            this.postFulfillmentStatusSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.PostFulfillmentStatusSpecification.invoke(block)
        }
    }
}
