// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeIntentResponse private constructor(builder: Builder) {
    /**
     * The identifier of the bot associated with the intent.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot associated with the intent.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * A timestamp of the date and time that the intent was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The description of the intent.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Lambda function called during each turn of a conversation with the intent.
     */
    val dialogCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings? = builder.dialogCodeHook
    /**
     * The Lambda function called when the intent is complete and ready for fulfillment.
     */
    val fulfillmentCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings? = builder.fulfillmentCodeHook
    /**
     * A list of contexts that must be active for the intent to be considered for sending to the user.
     */
    val inputContexts: List<InputContext>? = builder.inputContexts
    /**
     * The response that Amazon Lex sends to when the intent is closed.
     */
    val intentClosingSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting? = builder.intentClosingSetting
    /**
     * Prompts that Amazon Lex sends to the user to confirm completion of an intent.
     */
    val intentConfirmationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting? = builder.intentConfirmationSetting
    /**
     * The unique identifier assigned to the intent when it was created.
     */
    val intentId: kotlin.String? = builder.intentId
    /**
     * The name specified for the intent.
     */
    val intentName: kotlin.String? = builder.intentName
    /**
     * Configuration information required to use the `AMAZON.KendraSearchIntent` intent.
     */
    val kendraConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration? = builder.kendraConfiguration
    /**
     * A timestamp of the date and time that the intent was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The language and locale specified for the intent.
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * A list of contexts that are activated when the intent is fulfilled.
     */
    val outputContexts: List<OutputContext>? = builder.outputContexts
    /**
     * The identifier of the built-in intent that this intent is derived from, if any.
     */
    val parentIntentSignature: kotlin.String? = builder.parentIntentSignature
    /**
     * User utterances that trigger this intent.
     */
    val sampleUtterances: List<SampleUtterance>? = builder.sampleUtterances
    /**
     * The list that determines the priority that slots should be elicited from the user.
     */
    val slotPriorities: List<SlotPriority>? = builder.slotPriorities

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeIntentResponse(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("creationDateTime=$creationDateTime,")
        append("description=$description,")
        append("dialogCodeHook=$dialogCodeHook,")
        append("fulfillmentCodeHook=$fulfillmentCodeHook,")
        append("inputContexts=$inputContexts,")
        append("intentClosingSetting=$intentClosingSetting,")
        append("intentConfirmationSetting=$intentConfirmationSetting,")
        append("intentId=$intentId,")
        append("intentName=$intentName,")
        append("kendraConfiguration=$kendraConfiguration,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("localeId=$localeId,")
        append("outputContexts=$outputContexts,")
        append("parentIntentSignature=$parentIntentSignature,")
        append("sampleUtterances=$sampleUtterances,")
        append("slotPriorities=$slotPriorities)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dialogCodeHook?.hashCode() ?: 0)
        result = 31 * result + (fulfillmentCodeHook?.hashCode() ?: 0)
        result = 31 * result + (inputContexts?.hashCode() ?: 0)
        result = 31 * result + (intentClosingSetting?.hashCode() ?: 0)
        result = 31 * result + (intentConfirmationSetting?.hashCode() ?: 0)
        result = 31 * result + (intentId?.hashCode() ?: 0)
        result = 31 * result + (intentName?.hashCode() ?: 0)
        result = 31 * result + (kendraConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (outputContexts?.hashCode() ?: 0)
        result = 31 * result + (parentIntentSignature?.hashCode() ?: 0)
        result = 31 * result + (sampleUtterances?.hashCode() ?: 0)
        result = 31 * result + (slotPriorities?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeIntentResponse

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (creationDateTime != other.creationDateTime) return false
        if (description != other.description) return false
        if (dialogCodeHook != other.dialogCodeHook) return false
        if (fulfillmentCodeHook != other.fulfillmentCodeHook) return false
        if (inputContexts != other.inputContexts) return false
        if (intentClosingSetting != other.intentClosingSetting) return false
        if (intentConfirmationSetting != other.intentConfirmationSetting) return false
        if (intentId != other.intentId) return false
        if (intentName != other.intentName) return false
        if (kendraConfiguration != other.kendraConfiguration) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (localeId != other.localeId) return false
        if (outputContexts != other.outputContexts) return false
        if (parentIntentSignature != other.parentIntentSignature) return false
        if (sampleUtterances != other.sampleUtterances) return false
        if (slotPriorities != other.slotPriorities) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the bot associated with the intent.
         */
        var botId: kotlin.String? = null
        /**
         * The version of the bot associated with the intent.
         */
        var botVersion: kotlin.String? = null
        /**
         * A timestamp of the date and time that the intent was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the intent.
         */
        var description: kotlin.String? = null
        /**
         * The Lambda function called during each turn of a conversation with the intent.
         */
        var dialogCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings? = null
        /**
         * The Lambda function called when the intent is complete and ready for fulfillment.
         */
        var fulfillmentCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings? = null
        /**
         * A list of contexts that must be active for the intent to be considered for sending to the user.
         */
        var inputContexts: List<InputContext>? = null
        /**
         * The response that Amazon Lex sends to when the intent is closed.
         */
        var intentClosingSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting? = null
        /**
         * Prompts that Amazon Lex sends to the user to confirm completion of an intent.
         */
        var intentConfirmationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting? = null
        /**
         * The unique identifier assigned to the intent when it was created.
         */
        var intentId: kotlin.String? = null
        /**
         * The name specified for the intent.
         */
        var intentName: kotlin.String? = null
        /**
         * Configuration information required to use the `AMAZON.KendraSearchIntent` intent.
         */
        var kendraConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration? = null
        /**
         * A timestamp of the date and time that the intent was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The language and locale specified for the intent.
         */
        var localeId: kotlin.String? = null
        /**
         * A list of contexts that are activated when the intent is fulfilled.
         */
        var outputContexts: List<OutputContext>? = null
        /**
         * The identifier of the built-in intent that this intent is derived from, if any.
         */
        var parentIntentSignature: kotlin.String? = null
        /**
         * User utterances that trigger this intent.
         */
        var sampleUtterances: List<SampleUtterance>? = null
        /**
         * The list that determines the priority that slots should be elicited from the user.
         */
        var slotPriorities: List<SlotPriority>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentResponse) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.creationDateTime = x.creationDateTime
            this.description = x.description
            this.dialogCodeHook = x.dialogCodeHook
            this.fulfillmentCodeHook = x.fulfillmentCodeHook
            this.inputContexts = x.inputContexts
            this.intentClosingSetting = x.intentClosingSetting
            this.intentConfirmationSetting = x.intentConfirmationSetting
            this.intentId = x.intentId
            this.intentName = x.intentName
            this.kendraConfiguration = x.kendraConfiguration
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.localeId = x.localeId
            this.outputContexts = x.outputContexts
            this.parentIntentSignature = x.parentIntentSignature
            this.sampleUtterances = x.sampleUtterances
            this.slotPriorities = x.slotPriorities
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentResponse = DescribeIntentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings] inside the given [block]
         */
        fun dialogCodeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings.Builder.() -> kotlin.Unit) {
            this.dialogCodeHook = aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings] inside the given [block]
         */
        fun fulfillmentCodeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings.Builder.() -> kotlin.Unit) {
            this.fulfillmentCodeHook = aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting] inside the given [block]
         */
        fun intentClosingSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting.Builder.() -> kotlin.Unit) {
            this.intentClosingSetting = aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting] inside the given [block]
         */
        fun intentConfirmationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting.Builder.() -> kotlin.Unit) {
            this.intentConfirmationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration] inside the given [block]
         */
        fun kendraConfiguration(block: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration.Builder.() -> kotlin.Unit) {
            this.kendraConfiguration = aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration.invoke(block)
        }
    }
}
