// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeBotLocaleResponse private constructor(builder: Builder) {
    /**
     * The identifier of the bot associated with the locale.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * History of changes, such as when a locale is used in an alias, that have taken place for the locale.
     */
    val botLocaleHistoryEvents: List<BotLocaleHistoryEvent>? = builder.botLocaleHistoryEvents
    /**
     * The status of the bot. If the status is `Failed`, the reasons for the failure are listed in the `failureReasons` field.
     */
    val botLocaleStatus: aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleStatus? = builder.botLocaleStatus
    /**
     * The identifier of the version of the bot associated with the locale.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * The date and time that the locale was created.
     */
    val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The description of the locale.
     */
    val description: kotlin.String? = builder.description
    /**
     * if `botLocaleStatus` is `Failed`, Amazon Lex explains why it failed to build the bot.
     */
    val failureReasons: List<String>? = builder.failureReasons
    /**
     * The number of intents defined for the locale.
     */
    val intentsCount: kotlin.Int? = builder.intentsCount
    /**
     * The date and time that the locale was last submitted for building.
     */
    val lastBuildSubmittedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastBuildSubmittedDateTime
    /**
     * The date and time that the locale was last updated.
     */
    val lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDateTime
    /**
     * The unique identifier of the described locale.
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * The name of the locale.
     */
    val localeName: kotlin.String? = builder.localeName
    /**
     * The confidence threshold where Amazon Lex inserts the `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` intents in the list of possible intents for an utterance.
     */
    val nluIntentConfidenceThreshold: kotlin.Double? = builder.nluIntentConfidenceThreshold
    /**
     * Recommended actions to take to resolve an error in the `failureReasons` field.
     */
    val recommendedActions: List<String>? = builder.recommendedActions
    /**
     * The number of slot types defined for the locale.
     */
    val slotTypesCount: kotlin.Int? = builder.slotTypesCount
    /**
     * The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
     */
    val voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = builder.voiceSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBotLocaleResponse(")
        append("botId=$botId,")
        append("botLocaleHistoryEvents=$botLocaleHistoryEvents,")
        append("botLocaleStatus=$botLocaleStatus,")
        append("botVersion=$botVersion,")
        append("creationDateTime=$creationDateTime,")
        append("description=$description,")
        append("failureReasons=$failureReasons,")
        append("intentsCount=$intentsCount,")
        append("lastBuildSubmittedDateTime=$lastBuildSubmittedDateTime,")
        append("lastUpdatedDateTime=$lastUpdatedDateTime,")
        append("localeId=$localeId,")
        append("localeName=$localeName,")
        append("nluIntentConfidenceThreshold=$nluIntentConfidenceThreshold,")
        append("recommendedActions=$recommendedActions,")
        append("slotTypesCount=$slotTypesCount,")
        append("voiceSettings=$voiceSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botLocaleHistoryEvents?.hashCode() ?: 0)
        result = 31 * result + (botLocaleStatus?.hashCode() ?: 0)
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (failureReasons?.hashCode() ?: 0)
        result = 31 * result + (intentsCount ?: 0)
        result = 31 * result + (lastBuildSubmittedDateTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDateTime?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (localeName?.hashCode() ?: 0)
        result = 31 * result + (nluIntentConfidenceThreshold?.hashCode() ?: 0)
        result = 31 * result + (recommendedActions?.hashCode() ?: 0)
        result = 31 * result + (slotTypesCount ?: 0)
        result = 31 * result + (voiceSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBotLocaleResponse

        if (botId != other.botId) return false
        if (botLocaleHistoryEvents != other.botLocaleHistoryEvents) return false
        if (botLocaleStatus != other.botLocaleStatus) return false
        if (botVersion != other.botVersion) return false
        if (creationDateTime != other.creationDateTime) return false
        if (description != other.description) return false
        if (failureReasons != other.failureReasons) return false
        if (intentsCount != other.intentsCount) return false
        if (lastBuildSubmittedDateTime != other.lastBuildSubmittedDateTime) return false
        if (lastUpdatedDateTime != other.lastUpdatedDateTime) return false
        if (localeId != other.localeId) return false
        if (localeName != other.localeName) return false
        if (nluIntentConfidenceThreshold != other.nluIntentConfidenceThreshold) return false
        if (recommendedActions != other.recommendedActions) return false
        if (slotTypesCount != other.slotTypesCount) return false
        if (voiceSettings != other.voiceSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the bot associated with the locale.
         */
        var botId: kotlin.String? = null
        /**
         * History of changes, such as when a locale is used in an alias, that have taken place for the locale.
         */
        var botLocaleHistoryEvents: List<BotLocaleHistoryEvent>? = null
        /**
         * The status of the bot. If the status is `Failed`, the reasons for the failure are listed in the `failureReasons` field.
         */
        var botLocaleStatus: aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleStatus? = null
        /**
         * The identifier of the version of the bot associated with the locale.
         */
        var botVersion: kotlin.String? = null
        /**
         * The date and time that the locale was created.
         */
        var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the locale.
         */
        var description: kotlin.String? = null
        /**
         * if `botLocaleStatus` is `Failed`, Amazon Lex explains why it failed to build the bot.
         */
        var failureReasons: List<String>? = null
        /**
         * The number of intents defined for the locale.
         */
        var intentsCount: kotlin.Int? = null
        /**
         * The date and time that the locale was last submitted for building.
         */
        var lastBuildSubmittedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the locale was last updated.
         */
        var lastUpdatedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the described locale.
         */
        var localeId: kotlin.String? = null
        /**
         * The name of the locale.
         */
        var localeName: kotlin.String? = null
        /**
         * The confidence threshold where Amazon Lex inserts the `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` intents in the list of possible intents for an utterance.
         */
        var nluIntentConfidenceThreshold: kotlin.Double? = null
        /**
         * Recommended actions to take to resolve an error in the `failureReasons` field.
         */
        var recommendedActions: List<String>? = null
        /**
         * The number of slot types defined for the locale.
         */
        var slotTypesCount: kotlin.Int? = null
        /**
         * The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
         */
        var voiceSettings: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse) : this() {
            this.botId = x.botId
            this.botLocaleHistoryEvents = x.botLocaleHistoryEvents
            this.botLocaleStatus = x.botLocaleStatus
            this.botVersion = x.botVersion
            this.creationDateTime = x.creationDateTime
            this.description = x.description
            this.failureReasons = x.failureReasons
            this.intentsCount = x.intentsCount
            this.lastBuildSubmittedDateTime = x.lastBuildSubmittedDateTime
            this.lastUpdatedDateTime = x.lastUpdatedDateTime
            this.localeId = x.localeId
            this.localeName = x.localeName
            this.nluIntentConfidenceThreshold = x.nluIntentConfidenceThreshold
            this.recommendedActions = x.recommendedActions
            this.slotTypesCount = x.slotTypesCount
            this.voiceSettings = x.voiceSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse = DescribeBotLocaleResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings] inside the given [block]
         */
        fun voiceSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.Builder.() -> kotlin.Unit) {
            this.voiceSettings = aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings.invoke(block)
        }
    }
}
