// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



class CreateSlotRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bot associated with the slot.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot associated with the slot.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * A description of the slot. Use this to help identify the slot in lists.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the intent that contains the slot.
     */
    val intentId: kotlin.String? = builder.intentId
    /**
     * The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to `true` in any other locale, Amazon Lex throws a `ValidationException`.
     *
     * If the `multipleValuesSetting` is not set, the default value is `false`.
     */
    val multipleValuesSetting: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting? = builder.multipleValuesSetting
    /**
     * Determines how slot values are used in Amazon CloudWatch logs. If the value of the `obfuscationSetting` parameter is `DefaultObfuscation`, slot values are obfuscated in the log output. If the value is `None`, the actual value is present in the log output.
     *
     * The default is to obfuscate values in the CloudWatch logs.
     */
    val obfuscationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting? = builder.obfuscationSetting
    /**
     * The name of the slot. Slot names must be unique within the bot that contains the slot.
     */
    val slotName: kotlin.String? = builder.slotName
    /**
     * The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.
     */
    val slotTypeId: kotlin.String? = builder.slotTypeId
    /**
     * Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     */
    val valueElicitationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting? = builder.valueElicitationSetting

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSlotRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("description=$description,")
        append("intentId=$intentId,")
        append("localeId=$localeId,")
        append("multipleValuesSetting=$multipleValuesSetting,")
        append("obfuscationSetting=$obfuscationSetting,")
        append("slotName=$slotName,")
        append("slotTypeId=$slotTypeId,")
        append("valueElicitationSetting=$valueElicitationSetting)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (intentId?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (multipleValuesSetting?.hashCode() ?: 0)
        result = 31 * result + (obfuscationSetting?.hashCode() ?: 0)
        result = 31 * result + (slotName?.hashCode() ?: 0)
        result = 31 * result + (slotTypeId?.hashCode() ?: 0)
        result = 31 * result + (valueElicitationSetting?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSlotRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (description != other.description) return false
        if (intentId != other.intentId) return false
        if (localeId != other.localeId) return false
        if (multipleValuesSetting != other.multipleValuesSetting) return false
        if (obfuscationSetting != other.obfuscationSetting) return false
        if (slotName != other.slotName) return false
        if (slotTypeId != other.slotTypeId) return false
        if (valueElicitationSetting != other.valueElicitationSetting) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the bot associated with the slot.
         */
        var botId: kotlin.String? = null
        /**
         * The version of the bot associated with the slot.
         */
        var botVersion: kotlin.String? = null
        /**
         * A description of the slot. Use this to help identify the slot in lists.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the intent that contains the slot.
         */
        var intentId: kotlin.String? = null
        /**
         * The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        var localeId: kotlin.String? = null
        /**
         * Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to `true` in any other locale, Amazon Lex throws a `ValidationException`.
         *
         * If the `multipleValuesSetting` is not set, the default value is `false`.
         */
        var multipleValuesSetting: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting? = null
        /**
         * Determines how slot values are used in Amazon CloudWatch logs. If the value of the `obfuscationSetting` parameter is `DefaultObfuscation`, slot values are obfuscated in the log output. If the value is `None`, the actual value is present in the log output.
         *
         * The default is to obfuscate values in the CloudWatch logs.
         */
        var obfuscationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting? = null
        /**
         * The name of the slot. Slot names must be unique within the bot that contains the slot.
         */
        var slotName: kotlin.String? = null
        /**
         * The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.
         */
        var slotTypeId: kotlin.String? = null
        /**
         * Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
         */
        var valueElicitationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.description = x.description
            this.intentId = x.intentId
            this.localeId = x.localeId
            this.multipleValuesSetting = x.multipleValuesSetting
            this.obfuscationSetting = x.obfuscationSetting
            this.slotName = x.slotName
            this.slotTypeId = x.slotTypeId
            this.valueElicitationSetting = x.valueElicitationSetting
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotRequest = CreateSlotRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting] inside the given [block]
         */
        fun multipleValuesSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting.Builder.() -> kotlin.Unit) {
            this.multipleValuesSetting = aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting] inside the given [block]
         */
        fun obfuscationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting.Builder.() -> kotlin.Unit) {
            this.obfuscationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting] inside the given [block]
         */
        fun valueElicitationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting.Builder.() -> kotlin.Unit) {
            this.valueElicitationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting.invoke(block)
        }
    }
}
