// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



class CreateIntentRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bot associated with this intent.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * The identifier of the version of the bot associated with this intent.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * A description of the intent. Use the description to help identify the intent in lists.
     */
    val description: kotlin.String? = builder.description
    /**
     * Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.
     *
     * For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, `glutenIntolerant` to `true`. You might find John's phone number and set the corresponding session attribute.
     */
    val dialogCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings? = builder.dialogCodeHook
    /**
     * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.
     *
     * For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.
     */
    val fulfillmentCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings? = builder.fulfillmentCodeHook
    /**
     * A list of contexts that must be active for this intent to be considered by Amazon Lex.
     *
     * When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.
     *
     * A context can be automatically activated using the `outputContexts` property or it can be set at runtime.
     *
     *  For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.
     *
     * An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.
     */
    val inputContexts: List<InputContext>? = builder.inputContexts
    /**
     * Sets the response that Amazon Lex sends to the user when the intent is closed.
     */
    val intentClosingSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting? = builder.intentClosingSetting
    /**
     * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
     */
    val intentConfirmationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting? = builder.intentConfirmationSetting
    /**
     * The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
     */
    val intentName: kotlin.String? = builder.intentName
    /**
     * Configuration information required to use the `AMAZON.KendraSearchIntent` intent to connect to an Amazon Kendra index. The `AMAZON.KendraSearchIntent` intent is called when Amazon Lex can't determine another intent to invoke.
     */
    val kendraConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration? = builder.kendraConfiguration
    /**
     * The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * A lists of contexts that the intent activates when it is fulfilled.
     *
     * You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer.
     *
     * When you use the `outputContextsList` property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.
     */
    val outputContexts: List<OutputContext>? = builder.outputContexts
    /**
     * A unique identifier for the built-in intent to base this intent on.
     */
    val parentIntentSignature: kotlin.String? = builder.parentIntentSignature
    /**
     * An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza".
     *
     * In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user..
     */
    val sampleUtterances: List<SampleUtterance>? = builder.sampleUtterances

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIntentRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("description=$description,")
        append("dialogCodeHook=$dialogCodeHook,")
        append("fulfillmentCodeHook=$fulfillmentCodeHook,")
        append("inputContexts=$inputContexts,")
        append("intentClosingSetting=$intentClosingSetting,")
        append("intentConfirmationSetting=$intentConfirmationSetting,")
        append("intentName=$intentName,")
        append("kendraConfiguration=$kendraConfiguration,")
        append("localeId=$localeId,")
        append("outputContexts=$outputContexts,")
        append("parentIntentSignature=$parentIntentSignature,")
        append("sampleUtterances=$sampleUtterances)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dialogCodeHook?.hashCode() ?: 0)
        result = 31 * result + (fulfillmentCodeHook?.hashCode() ?: 0)
        result = 31 * result + (inputContexts?.hashCode() ?: 0)
        result = 31 * result + (intentClosingSetting?.hashCode() ?: 0)
        result = 31 * result + (intentConfirmationSetting?.hashCode() ?: 0)
        result = 31 * result + (intentName?.hashCode() ?: 0)
        result = 31 * result + (kendraConfiguration?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (outputContexts?.hashCode() ?: 0)
        result = 31 * result + (parentIntentSignature?.hashCode() ?: 0)
        result = 31 * result + (sampleUtterances?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIntentRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (description != other.description) return false
        if (dialogCodeHook != other.dialogCodeHook) return false
        if (fulfillmentCodeHook != other.fulfillmentCodeHook) return false
        if (inputContexts != other.inputContexts) return false
        if (intentClosingSetting != other.intentClosingSetting) return false
        if (intentConfirmationSetting != other.intentConfirmationSetting) return false
        if (intentName != other.intentName) return false
        if (kendraConfiguration != other.kendraConfiguration) return false
        if (localeId != other.localeId) return false
        if (outputContexts != other.outputContexts) return false
        if (parentIntentSignature != other.parentIntentSignature) return false
        if (sampleUtterances != other.sampleUtterances) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the bot associated with this intent.
         */
        var botId: kotlin.String? = null
        /**
         * The identifier of the version of the bot associated with this intent.
         */
        var botVersion: kotlin.String? = null
        /**
         * A description of the intent. Use the description to help identify the intent in lists.
         */
        var description: kotlin.String? = null
        /**
         * Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.
         *
         * For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, `glutenIntolerant` to `true`. You might find John's phone number and set the corresponding session attribute.
         */
        var dialogCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings? = null
        /**
         * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.
         *
         * For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.
         */
        var fulfillmentCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings? = null
        /**
         * A list of contexts that must be active for this intent to be considered by Amazon Lex.
         *
         * When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.
         *
         * A context can be automatically activated using the `outputContexts` property or it can be set at runtime.
         *
         *  For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.
         *
         * An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.
         */
        var inputContexts: List<InputContext>? = null
        /**
         * Sets the response that Amazon Lex sends to the user when the intent is closed.
         */
        var intentClosingSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting? = null
        /**
         * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
         */
        var intentConfirmationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting? = null
        /**
         * The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
         */
        var intentName: kotlin.String? = null
        /**
         * Configuration information required to use the `AMAZON.KendraSearchIntent` intent to connect to an Amazon Kendra index. The `AMAZON.KendraSearchIntent` intent is called when Amazon Lex can't determine another intent to invoke.
         */
        var kendraConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration? = null
        /**
         * The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        var localeId: kotlin.String? = null
        /**
         * A lists of contexts that the intent activates when it is fulfilled.
         *
         * You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer.
         *
         * When you use the `outputContextsList` property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.
         */
        var outputContexts: List<OutputContext>? = null
        /**
         * A unique identifier for the built-in intent to base this intent on.
         */
        var parentIntentSignature: kotlin.String? = null
        /**
         * An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza".
         *
         * In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user..
         */
        var sampleUtterances: List<SampleUtterance>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.description = x.description
            this.dialogCodeHook = x.dialogCodeHook
            this.fulfillmentCodeHook = x.fulfillmentCodeHook
            this.inputContexts = x.inputContexts
            this.intentClosingSetting = x.intentClosingSetting
            this.intentConfirmationSetting = x.intentConfirmationSetting
            this.intentName = x.intentName
            this.kendraConfiguration = x.kendraConfiguration
            this.localeId = x.localeId
            this.outputContexts = x.outputContexts
            this.parentIntentSignature = x.parentIntentSignature
            this.sampleUtterances = x.sampleUtterances
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentRequest = CreateIntentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings] inside the given [block]
         */
        fun dialogCodeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings.Builder.() -> kotlin.Unit) {
            this.dialogCodeHook = aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings] inside the given [block]
         */
        fun fulfillmentCodeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings.Builder.() -> kotlin.Unit) {
            this.fulfillmentCodeHook = aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting] inside the given [block]
         */
        fun intentClosingSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting.Builder.() -> kotlin.Unit) {
            this.intentClosingSetting = aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting] inside the given [block]
         */
        fun intentConfirmationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting.Builder.() -> kotlin.Unit) {
            this.intentConfirmationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration] inside the given [block]
         */
        fun kendraConfiguration(block: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration.Builder.() -> kotlin.Unit) {
            this.kendraConfiguration = aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration.invoke(block)
        }
    }
}
