// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Provides the bot parameters required for importing a bot.
 */
class BotImportSpecification private constructor(builder: Builder) {
    /**
     * The name that Amazon Lex should use for the bot.
     */
    val botName: kotlin.String? = builder.botName
    /**
     * A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the `UpdateBot` operation to update tags. To update tags, use the `TagResource` operation.
     */
    val botTags: Map<String, String>? = builder.botTags
    /**
     * By default, data stored by Amazon Lex is encrypted. The `DataPrivacy` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.
     */
    val dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = builder.dataPrivacy
    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     *
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    val idleSessionTtlInSeconds: kotlin.Int? = builder.idleSessionTtlInSeconds
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use the `UpdateAlias` operation to update tags. To update tags on the test alias, use the `TagResource` operation.
     */
    val testBotAliasTags: Map<String, String>? = builder.testBotAliasTags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BotImportSpecification(")
        append("botName=$botName,")
        append("botTags=$botTags,")
        append("dataPrivacy=$dataPrivacy,")
        append("idleSessionTtlInSeconds=$idleSessionTtlInSeconds,")
        append("roleArn=$roleArn,")
        append("testBotAliasTags=$testBotAliasTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botName?.hashCode() ?: 0
        result = 31 * result + (botTags?.hashCode() ?: 0)
        result = 31 * result + (dataPrivacy?.hashCode() ?: 0)
        result = 31 * result + (idleSessionTtlInSeconds ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (testBotAliasTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BotImportSpecification

        if (botName != other.botName) return false
        if (botTags != other.botTags) return false
        if (dataPrivacy != other.dataPrivacy) return false
        if (idleSessionTtlInSeconds != other.idleSessionTtlInSeconds) return false
        if (roleArn != other.roleArn) return false
        if (testBotAliasTags != other.testBotAliasTags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name that Amazon Lex should use for the bot.
         */
        var botName: kotlin.String? = null
        /**
         * A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the `UpdateBot` operation to update tags. To update tags, use the `TagResource` operation.
         */
        var botTags: Map<String, String>? = null
        /**
         * By default, data stored by Amazon Lex is encrypted. The `DataPrivacy` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.
         */
        var dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = null
        /**
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         *
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         */
        var idleSessionTtlInSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
         */
        var roleArn: kotlin.String? = null
        /**
         * A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use the `UpdateAlias` operation to update tags. To update tags on the test alias, use the `TagResource` operation.
         */
        var testBotAliasTags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification) : this() {
            this.botName = x.botName
            this.botTags = x.botTags
            this.dataPrivacy = x.dataPrivacy
            this.idleSessionTtlInSeconds = x.idleSessionTtlInSeconds
            this.roleArn = x.roleArn
            this.testBotAliasTags = x.testBotAliasTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification = BotImportSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy] inside the given [block]
         */
        fun dataPrivacy(block: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.Builder.() -> kotlin.Unit) {
            this.dataPrivacy = aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.invoke(block)
        }
    }
}
