// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.lexmodelsv2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.lexmodelsv2.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 *
 */
interface LexModelsV2Client : SdkClient {

    override val serviceName: String
        get() = "Lex Models V2"
    /**
     * LexModelsV2Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): LexModelsV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultLexModelsV2Client(config)
        }

        operator fun invoke(config: Config): LexModelsV2Client = DefaultLexModelsV2Client(config)

        /**
         * Construct a [LexModelsV2Client] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LexModelsV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultLexModelsV2Client(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
     */
    suspend fun buildBotLocale(input: BuildBotLocaleRequest): BuildBotLocaleResponse

    /**
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
     */
    suspend fun buildBotLocale(block: BuildBotLocaleRequest.Builder.() -> Unit) = buildBotLocale(BuildBotLocaleRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Lex conversational bot.
     */
    suspend fun createBot(input: CreateBotRequest): CreateBotResponse

    /**
     * Creates an Amazon Lex conversational bot.
     */
    suspend fun createBot(block: CreateBotRequest.Builder.() -> Unit) = createBot(CreateBotRequest.Builder().apply(block).build())

    /**
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
     *
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     */
    suspend fun createBotAlias(input: CreateBotAliasRequest): CreateBotAliasResponse

    /**
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
     *
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     */
    suspend fun createBotAlias(block: CreateBotAliasRequest.Builder.() -> Unit) = createBotAlias(CreateBotAliasRequest.Builder().apply(block).build())

    /**
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
     */
    suspend fun createBotLocale(input: CreateBotLocaleRequest): CreateBotLocaleResponse

    /**
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
     */
    suspend fun createBotLocale(block: CreateBotLocaleRequest.Builder.() -> Unit) = createBotLocale(CreateBotLocaleRequest.Builder().apply(block).build())

    /**
     * Creates a new version of the bot based on the `DRAFT` version. If the `DRAFT` version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version.
     *
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     */
    suspend fun createBotVersion(input: CreateBotVersionRequest): CreateBotVersionResponse

    /**
     * Creates a new version of the bot based on the `DRAFT` version. If the `DRAFT` version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version.
     *
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     */
    suspend fun createBotVersion(block: CreateBotVersionRequest.Builder.() -> Unit) = createBotVersion(CreateBotVersionRequest.Builder().apply(block).build())

    /**
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
     *
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.
     *
     * For more information about exporting bots, and about the structure of the export archive, see [ Importing and exporting bots ](https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
     */
    suspend fun createExport(input: CreateExportRequest): CreateExportResponse

    /**
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
     *
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.
     *
     * For more information about exporting bots, and about the structure of the export archive, see [ Importing and exporting bots ](https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
     */
    suspend fun createExport(block: CreateExportRequest.Builder.() -> Unit) = createExport(CreateExportRequest.Builder().apply(block).build())

    /**
     * Creates an intent.
     *
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an `OrderPizza` intent.
     *
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * + Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.
     * + Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.
     * + How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.
     * + A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * + A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * + A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"
     */
    suspend fun createIntent(input: CreateIntentRequest): CreateIntentResponse

    /**
     * Creates an intent.
     *
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an `OrderPizza` intent.
     *
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * + Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.
     * + Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.
     * + How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.
     * + A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * + A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * + A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"
     */
    suspend fun createIntent(block: CreateIntentRequest.Builder.() -> Unit) = createIntent(CreateIntentRequest.Builder().apply(block).build())

    /**
     * Creates a new resource policy with the specified policy statements.
     */
    suspend fun createResourcePolicy(input: CreateResourcePolicyRequest): CreateResourcePolicyResponse

    /**
     * Creates a new resource policy with the specified policy statements.
     */
    suspend fun createResourcePolicy(block: CreateResourcePolicyRequest.Builder.() -> Unit) = createResourcePolicy(CreateResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
     *
     * You can't create a resource policy statement that allows cross-account access.
     */
    suspend fun createResourcePolicyStatement(input: CreateResourcePolicyStatementRequest): CreateResourcePolicyStatementResponse

    /**
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
     *
     * You can't create a resource policy statement that allows cross-account access.
     */
    suspend fun createResourcePolicyStatement(block: CreateResourcePolicyStatementRequest.Builder.() -> Unit) = createResourcePolicyStatement(CreateResourcePolicyStatementRequest.Builder().apply(block).build())

    /**
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
     */
    suspend fun createSlot(input: CreateSlotRequest): CreateSlotResponse

    /**
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
     */
    suspend fun createSlot(block: CreateSlotRequest.Builder.() -> Unit) = createSlot(CreateSlotRequest.Builder().apply(block).build())

    /**
     * Creates a custom slot type
     *
     *  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.
     */
    suspend fun createSlotType(input: CreateSlotTypeRequest): CreateSlotTypeResponse

    /**
     * Creates a custom slot type
     *
     *  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.
     */
    suspend fun createSlotType(block: CreateSlotTypeRequest.Builder.() -> Unit) = createSlotType(CreateSlotTypeRequest.Builder().apply(block).build())

    /**
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     */
    suspend fun createUploadUrl(input: CreateUploadUrlRequest = CreateUploadUrlRequest {}): CreateUploadUrlResponse

    /**
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     */
    suspend fun createUploadUrl(block: CreateUploadUrlRequest.Builder.() -> Unit) = createUploadUrl(CreateUploadUrlRequest.Builder().apply(block).build())

    /**
     * Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the `DeleteBotVersion` operation.
     *
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.
     *
     * If a bot has an alias, the `DeleteBot` operation returns a `ResourceInUseException` exception. If you want to delete the bot and the alias, set the `skipResourceInUseCheck` parameter to `true`.
     */
    suspend fun deleteBot(input: DeleteBotRequest): DeleteBotResponse

    /**
     * Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the `DeleteBotVersion` operation.
     *
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.
     *
     * If a bot has an alias, the `DeleteBot` operation returns a `ResourceInUseException` exception. If you want to delete the bot and the alias, set the `skipResourceInUseCheck` parameter to `true`.
     */
    suspend fun deleteBot(block: DeleteBotRequest.Builder.() -> Unit) = deleteBot(DeleteBotRequest.Builder().apply(block).build())

    /**
     * Deletes the specified bot alias.
     */
    suspend fun deleteBotAlias(input: DeleteBotAliasRequest): DeleteBotAliasResponse

    /**
     * Deletes the specified bot alias.
     */
    suspend fun deleteBotAlias(block: DeleteBotAliasRequest.Builder.() -> Unit) = deleteBotAlias(DeleteBotAliasRequest.Builder().apply(block).build())

    /**
     * Removes a locale from a bot.
     *
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     */
    suspend fun deleteBotLocale(input: DeleteBotLocaleRequest): DeleteBotLocaleResponse

    /**
     * Removes a locale from a bot.
     *
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     */
    suspend fun deleteBotLocale(block: DeleteBotLocaleRequest.Builder.() -> Unit) = deleteBotLocale(DeleteBotLocaleRequest.Builder().apply(block).build())

    /**
     * Deletes a specific version of a bot. To delete all version of a bot, use the [DeleteBot](https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html) operation.
     */
    suspend fun deleteBotVersion(input: DeleteBotVersionRequest): DeleteBotVersionResponse

    /**
     * Deletes a specific version of a bot. To delete all version of a bot, use the [DeleteBot](https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html) operation.
     */
    suspend fun deleteBotVersion(block: DeleteBotVersionRequest.Builder.() -> Unit) = deleteBotVersion(DeleteBotVersionRequest.Builder().apply(block).build())

    /**
     * Removes a custom vocabulary from the specified locale in the specified bot.
     */
    suspend fun deleteCustomVocabulary(input: DeleteCustomVocabularyRequest): DeleteCustomVocabularyResponse

    /**
     * Removes a custom vocabulary from the specified locale in the specified bot.
     */
    suspend fun deleteCustomVocabulary(block: DeleteCustomVocabularyRequest.Builder.() -> Unit) = deleteCustomVocabulary(DeleteCustomVocabularyRequest.Builder().apply(block).build())

    /**
     * Removes a previous export and the associated files stored in an S3 bucket.
     */
    suspend fun deleteExport(input: DeleteExportRequest): DeleteExportResponse

    /**
     * Removes a previous export and the associated files stored in an S3 bucket.
     */
    suspend fun deleteExport(block: DeleteExportRequest.Builder.() -> Unit) = deleteExport(DeleteExportRequest.Builder().apply(block).build())

    /**
     * Removes a previous import and the associated file stored in an S3 bucket.
     */
    suspend fun deleteImport(input: DeleteImportRequest): DeleteImportResponse

    /**
     * Removes a previous import and the associated file stored in an S3 bucket.
     */
    suspend fun deleteImport(block: DeleteImportRequest.Builder.() -> Unit) = deleteImport(DeleteImportRequest.Builder().apply(block).build())

    /**
     * Removes the specified intent.
     *
     * Deleting an intent also deletes the slots associated with the intent.
     */
    suspend fun deleteIntent(input: DeleteIntentRequest): DeleteIntentResponse

    /**
     * Removes the specified intent.
     *
     * Deleting an intent also deletes the slots associated with the intent.
     */
    suspend fun deleteIntent(block: DeleteIntentRequest.Builder.() -> Unit) = deleteIntent(DeleteIntentRequest.Builder().apply(block).build())

    /**
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
     */
    suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
     */
    suspend fun deleteResourcePolicy(block: DeleteResourcePolicyRequest.Builder.() -> Unit) = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
     */
    suspend fun deleteResourcePolicyStatement(input: DeleteResourcePolicyStatementRequest): DeleteResourcePolicyStatementResponse

    /**
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
     */
    suspend fun deleteResourcePolicyStatement(block: DeleteResourcePolicyStatementRequest.Builder.() -> Unit) = deleteResourcePolicyStatement(DeleteResourcePolicyStatementRequest.Builder().apply(block).build())

    /**
     * Deletes the specified slot from an intent.
     */
    suspend fun deleteSlot(input: DeleteSlotRequest): DeleteSlotResponse

    /**
     * Deletes the specified slot from an intent.
     */
    suspend fun deleteSlot(block: DeleteSlotRequest.Builder.() -> Unit) = deleteSlot(DeleteSlotRequest.Builder().apply(block).build())

    /**
     * Deletes a slot type from a bot locale.
     *
     * If a slot is using the slot type, Amazon Lex throws a `ResourceInUseException` exception. To avoid the exception, set the `skipResourceInUseCheck` parameter to `true`.
     */
    suspend fun deleteSlotType(input: DeleteSlotTypeRequest): DeleteSlotTypeResponse

    /**
     * Deletes a slot type from a bot locale.
     *
     * If a slot is using the slot type, Amazon Lex throws a `ResourceInUseException` exception. To avoid the exception, set the `skipResourceInUseCheck` parameter to `true`.
     */
    suspend fun deleteSlotType(block: DeleteSlotTypeRequest.Builder.() -> Unit) = deleteSlotType(DeleteSlotTypeRequest.Builder().apply(block).build())

    /**
     * Deletes stored utterances.
     *
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html) operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..
     *
     * Use the `DeleteUtterances` operation to manually delete utterances for a specific session. When you use the `DeleteUtterances` operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the `ListAggregatedUtterances` operation are deleted after 15 days.
     */
    suspend fun deleteUtterances(input: DeleteUtterancesRequest): DeleteUtterancesResponse

    /**
     * Deletes stored utterances.
     *
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html) operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..
     *
     * Use the `DeleteUtterances` operation to manually delete utterances for a specific session. When you use the `DeleteUtterances` operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the `ListAggregatedUtterances` operation are deleted after 15 days.
     */
    suspend fun deleteUtterances(block: DeleteUtterancesRequest.Builder.() -> Unit) = deleteUtterances(DeleteUtterancesRequest.Builder().apply(block).build())

    /**
     * Provides metadata information about a bot.
     */
    suspend fun describeBot(input: DescribeBotRequest): DescribeBotResponse

    /**
     * Provides metadata information about a bot.
     */
    suspend fun describeBot(block: DescribeBotRequest.Builder.() -> Unit) = describeBot(DescribeBotRequest.Builder().apply(block).build())

    /**
     * Get information about a specific bot alias.
     */
    suspend fun describeBotAlias(input: DescribeBotAliasRequest): DescribeBotAliasResponse

    /**
     * Get information about a specific bot alias.
     */
    suspend fun describeBotAlias(block: DescribeBotAliasRequest.Builder.() -> Unit) = describeBotAlias(DescribeBotAliasRequest.Builder().apply(block).build())

    /**
     * Describes the settings that a bot has for a specific locale.
     */
    suspend fun describeBotLocale(input: DescribeBotLocaleRequest): DescribeBotLocaleResponse

    /**
     * Describes the settings that a bot has for a specific locale.
     */
    suspend fun describeBotLocale(block: DescribeBotLocaleRequest.Builder.() -> Unit) = describeBotLocale(DescribeBotLocaleRequest.Builder().apply(block).build())

    /**
     * Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
     */
    suspend fun describeBotRecommendation(input: DescribeBotRecommendationRequest): DescribeBotRecommendationResponse

    /**
     * Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
     */
    suspend fun describeBotRecommendation(block: DescribeBotRecommendationRequest.Builder.() -> Unit) = describeBotRecommendation(DescribeBotRecommendationRequest.Builder().apply(block).build())

    /**
     * Provides metadata about a version of a bot.
     */
    suspend fun describeBotVersion(input: DescribeBotVersionRequest): DescribeBotVersionResponse

    /**
     * Provides metadata about a version of a bot.
     */
    suspend fun describeBotVersion(block: DescribeBotVersionRequest.Builder.() -> Unit) = describeBotVersion(DescribeBotVersionRequest.Builder().apply(block).build())

    /**
     * Provides metadata information about a custom vocabulary.
     */
    suspend fun describeCustomVocabularyMetadata(input: DescribeCustomVocabularyMetadataRequest): DescribeCustomVocabularyMetadataResponse

    /**
     * Provides metadata information about a custom vocabulary.
     */
    suspend fun describeCustomVocabularyMetadata(block: DescribeCustomVocabularyMetadataRequest.Builder.() -> Unit) = describeCustomVocabularyMetadata(DescribeCustomVocabularyMetadataRequest.Builder().apply(block).build())

    /**
     * Gets information about a specific export.
     */
    suspend fun describeExport(input: DescribeExportRequest): DescribeExportResponse

    /**
     * Gets information about a specific export.
     */
    suspend fun describeExport(block: DescribeExportRequest.Builder.() -> Unit) = describeExport(DescribeExportRequest.Builder().apply(block).build())

    /**
     * Gets information about a specific import.
     */
    suspend fun describeImport(input: DescribeImportRequest): DescribeImportResponse

    /**
     * Gets information about a specific import.
     */
    suspend fun describeImport(block: DescribeImportRequest.Builder.() -> Unit) = describeImport(DescribeImportRequest.Builder().apply(block).build())

    /**
     * Returns metadata about an intent.
     */
    suspend fun describeIntent(input: DescribeIntentRequest): DescribeIntentResponse

    /**
     * Returns metadata about an intent.
     */
    suspend fun describeIntent(block: DescribeIntentRequest.Builder.() -> Unit) = describeIntent(DescribeIntentRequest.Builder().apply(block).build())

    /**
     * Gets the resource policy and policy revision for a bot or bot alias.
     */
    suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse

    /**
     * Gets the resource policy and policy revision for a bot or bot alias.
     */
    suspend fun describeResourcePolicy(block: DescribeResourcePolicyRequest.Builder.() -> Unit) = describeResourcePolicy(DescribeResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Gets metadata information about a slot.
     */
    suspend fun describeSlot(input: DescribeSlotRequest): DescribeSlotResponse

    /**
     * Gets metadata information about a slot.
     */
    suspend fun describeSlot(block: DescribeSlotRequest.Builder.() -> Unit) = describeSlot(DescribeSlotRequest.Builder().apply(block).build())

    /**
     * Gets metadata information about a slot type.
     */
    suspend fun describeSlotType(input: DescribeSlotTypeRequest): DescribeSlotTypeResponse

    /**
     * Gets metadata information about a slot type.
     */
    suspend fun describeSlotType(block: DescribeSlotTypeRequest.Builder.() -> Unit) = describeSlotType(DescribeSlotTypeRequest.Builder().apply(block).build())

    /**
     * Provides a list of utterances that users have sent to the bot.
     *
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.
     *
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.
     *
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     *
     * Utterances statistics are not generated under the following conditions:
     * + The `childDirected` field was set to true when the bot was created.
     * + You are using slot obfuscation with one or more slots.
     * + You opted out of participating in improving Amazon Lex.
     */
    suspend fun listAggregatedUtterances(input: ListAggregatedUtterancesRequest): ListAggregatedUtterancesResponse

    /**
     * Provides a list of utterances that users have sent to the bot.
     *
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.
     *
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.
     *
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     *
     * Utterances statistics are not generated under the following conditions:
     * + The `childDirected` field was set to true when the bot was created.
     * + You are using slot obfuscation with one or more slots.
     * + You opted out of participating in improving Amazon Lex.
     */
    suspend fun listAggregatedUtterances(block: ListAggregatedUtterancesRequest.Builder.() -> Unit) = listAggregatedUtterances(ListAggregatedUtterancesRequest.Builder().apply(block).build())

    /**
     * Gets a list of aliases for the specified bot.
     */
    suspend fun listBotAliases(input: ListBotAliasesRequest): ListBotAliasesResponse

    /**
     * Gets a list of aliases for the specified bot.
     */
    suspend fun listBotAliases(block: ListBotAliasesRequest.Builder.() -> Unit) = listBotAliases(ListBotAliasesRequest.Builder().apply(block).build())

    /**
     * Gets a list of locales for the specified bot.
     */
    suspend fun listBotLocales(input: ListBotLocalesRequest): ListBotLocalesResponse

    /**
     * Gets a list of locales for the specified bot.
     */
    suspend fun listBotLocales(block: ListBotLocalesRequest.Builder.() -> Unit) = listBotLocales(ListBotLocalesRequest.Builder().apply(block).build())

    /**
     * Get a list of bot recommendations that meet the specified criteria.
     */
    suspend fun listBotRecommendations(input: ListBotRecommendationsRequest): ListBotRecommendationsResponse

    /**
     * Get a list of bot recommendations that meet the specified criteria.
     */
    suspend fun listBotRecommendations(block: ListBotRecommendationsRequest.Builder.() -> Unit) = listBotRecommendations(ListBotRecommendationsRequest.Builder().apply(block).build())

    /**
     * Gets information about all of the versions of a bot.
     *
     * The `ListBotVersions` operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the `ListBotVersions` operation returns for summaries, one for each numbered version and one for the `DRAFT` version.
     *
     * The `ListBotVersions` operation always returns at least one version, the `DRAFT` version.
     */
    suspend fun listBotVersions(input: ListBotVersionsRequest): ListBotVersionsResponse

    /**
     * Gets information about all of the versions of a bot.
     *
     * The `ListBotVersions` operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the `ListBotVersions` operation returns for summaries, one for each numbered version and one for the `DRAFT` version.
     *
     * The `ListBotVersions` operation always returns at least one version, the `DRAFT` version.
     */
    suspend fun listBotVersions(block: ListBotVersionsRequest.Builder.() -> Unit) = listBotVersions(ListBotVersionsRequest.Builder().apply(block).build())

    /**
     * Gets a list of available bots.
     */
    suspend fun listBots(input: ListBotsRequest = ListBotsRequest {}): ListBotsResponse

    /**
     * Gets a list of available bots.
     */
    suspend fun listBots(block: ListBotsRequest.Builder.() -> Unit) = listBots(ListBotsRequest.Builder().apply(block).build())

    /**
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     *
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the `parentIntentSignature` parameter when you call the `CreateIntent` operation. For more information, see [CreateIntent](https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html).
     */
    suspend fun listBuiltInIntents(input: ListBuiltInIntentsRequest): ListBuiltInIntentsResponse

    /**
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     *
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the `parentIntentSignature` parameter when you call the `CreateIntent` operation. For more information, see [CreateIntent](https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html).
     */
    suspend fun listBuiltInIntents(block: ListBuiltInIntentsRequest.Builder.() -> Unit) = listBuiltInIntents(ListBuiltInIntentsRequest.Builder().apply(block).build())

    /**
     * Gets a list of built-in slot types that meet the specified criteria.
     */
    suspend fun listBuiltInSlotTypes(input: ListBuiltInSlotTypesRequest): ListBuiltInSlotTypesResponse

    /**
     * Gets a list of built-in slot types that meet the specified criteria.
     */
    suspend fun listBuiltInSlotTypes(block: ListBuiltInSlotTypesRequest.Builder.() -> Unit) = listBuiltInSlotTypes(ListBuiltInSlotTypesRequest.Builder().apply(block).build())

    /**
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     */
    suspend fun listExports(input: ListExportsRequest = ListExportsRequest {}): ListExportsResponse

    /**
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     */
    suspend fun listExports(block: ListExportsRequest.Builder.() -> Unit) = listExports(ListExportsRequest.Builder().apply(block).build())

    /**
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     */
    suspend fun listImports(input: ListImportsRequest = ListImportsRequest {}): ListImportsResponse

    /**
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     */
    suspend fun listImports(block: ListImportsRequest.Builder.() -> Unit) = listImports(ListImportsRequest.Builder().apply(block).build())

    /**
     * Get a list of intents that meet the specified criteria.
     */
    suspend fun listIntents(input: ListIntentsRequest): ListIntentsResponse

    /**
     * Get a list of intents that meet the specified criteria.
     */
    suspend fun listIntents(block: ListIntentsRequest.Builder.() -> Unit) = listIntents(ListIntentsRequest.Builder().apply(block).build())

    /**
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot.
     */
    suspend fun listRecommendedIntents(input: ListRecommendedIntentsRequest): ListRecommendedIntentsResponse

    /**
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot.
     */
    suspend fun listRecommendedIntents(block: ListRecommendedIntentsRequest.Builder.() -> Unit) = listRecommendedIntents(ListRecommendedIntentsRequest.Builder().apply(block).build())

    /**
     * Gets a list of slot types that match the specified criteria.
     */
    suspend fun listSlotTypes(input: ListSlotTypesRequest): ListSlotTypesResponse

    /**
     * Gets a list of slot types that match the specified criteria.
     */
    suspend fun listSlotTypes(block: ListSlotTypesRequest.Builder.() -> Unit) = listSlotTypes(ListSlotTypesRequest.Builder().apply(block).build())

    /**
     * Gets a list of slots that match the specified criteria.
     */
    suspend fun listSlots(input: ListSlotsRequest): ListSlotsResponse

    /**
     * Gets a list of slots that match the specified criteria.
     */
    suspend fun listSlots(block: ListSlotsRequest.Builder.() -> Unit) = listSlots(ListSlotsRequest.Builder().apply(block).build())

    /**
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Search for associated transcripts that meet the specified criteria.
     */
    suspend fun searchAssociatedTranscripts(input: SearchAssociatedTranscriptsRequest): SearchAssociatedTranscriptsResponse

    /**
     * Search for associated transcripts that meet the specified criteria.
     */
    suspend fun searchAssociatedTranscripts(block: SearchAssociatedTranscriptsRequest.Builder.() -> Unit) = searchAssociatedTranscripts(SearchAssociatedTranscriptsRequest.Builder().apply(block).build())

    /**
     * Use this to provide your transcript data, and to start the bot recommendation process.
     */
    suspend fun startBotRecommendation(input: StartBotRecommendationRequest): StartBotRecommendationResponse

    /**
     * Use this to provide your transcript data, and to start the bot recommendation process.
     */
    suspend fun startBotRecommendation(block: StartBotRecommendationRequest.Builder.() -> Unit) = startBotRecommendation(StartBotRecommendationRequest.Builder().apply(block).build())

    /**
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     */
    suspend fun startImport(input: StartImportRequest): StartImportResponse

    /**
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     */
    suspend fun startImport(block: StartImportRequest.Builder.() -> Unit) = startImport(StartImportRequest.Builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from a bot, bot alias, or bot channel.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from a bot, bot alias, or bot channel.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the configuration of an existing bot.
     */
    suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse

    /**
     * Updates the configuration of an existing bot.
     */
    suspend fun updateBot(block: UpdateBotRequest.Builder.() -> Unit) = updateBot(UpdateBotRequest.Builder().apply(block).build())

    /**
     * Updates the configuration of an existing bot alias.
     */
    suspend fun updateBotAlias(input: UpdateBotAliasRequest): UpdateBotAliasResponse

    /**
     * Updates the configuration of an existing bot alias.
     */
    suspend fun updateBotAlias(block: UpdateBotAliasRequest.Builder.() -> Unit) = updateBotAlias(UpdateBotAliasRequest.Builder().apply(block).build())

    /**
     * Updates the settings that a bot has for a specific locale.
     */
    suspend fun updateBotLocale(input: UpdateBotLocaleRequest): UpdateBotLocaleResponse

    /**
     * Updates the settings that a bot has for a specific locale.
     */
    suspend fun updateBotLocale(block: UpdateBotLocaleRequest.Builder.() -> Unit) = updateBotLocale(UpdateBotLocaleRequest.Builder().apply(block).build())

    /**
     * Updates an existing bot recommendation request.
     */
    suspend fun updateBotRecommendation(input: UpdateBotRecommendationRequest): UpdateBotRecommendationResponse

    /**
     * Updates an existing bot recommendation request.
     */
    suspend fun updateBotRecommendation(block: UpdateBotRecommendationRequest.Builder.() -> Unit) = updateBotRecommendation(UpdateBotRecommendationRequest.Builder().apply(block).build())

    /**
     * Updates the password used to protect an export zip archive.
     *
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the [DescribeExport](https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html) operation.
     */
    suspend fun updateExport(input: UpdateExportRequest): UpdateExportResponse

    /**
     * Updates the password used to protect an export zip archive.
     *
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the [DescribeExport](https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html) operation.
     */
    suspend fun updateExport(block: UpdateExportRequest.Builder.() -> Unit) = updateExport(UpdateExportRequest.Builder().apply(block).build())

    /**
     * Updates the settings for an intent.
     */
    suspend fun updateIntent(input: UpdateIntentRequest): UpdateIntentResponse

    /**
     * Updates the settings for an intent.
     */
    suspend fun updateIntent(block: UpdateIntentRequest.Builder.() -> Unit) = updateIntent(UpdateIntentRequest.Builder().apply(block).build())

    /**
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
     */
    suspend fun updateResourcePolicy(input: UpdateResourcePolicyRequest): UpdateResourcePolicyResponse

    /**
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
     */
    suspend fun updateResourcePolicy(block: UpdateResourcePolicyRequest.Builder.() -> Unit) = updateResourcePolicy(UpdateResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Updates the settings for a slot.
     */
    suspend fun updateSlot(input: UpdateSlotRequest): UpdateSlotResponse

    /**
     * Updates the settings for a slot.
     */
    suspend fun updateSlot(block: UpdateSlotRequest.Builder.() -> Unit) = updateSlot(UpdateSlotRequest.Builder().apply(block).build())

    /**
     * Updates the configuration of an existing slot type.
     */
    suspend fun updateSlotType(input: UpdateSlotTypeRequest): UpdateSlotTypeResponse

    /**
     * Updates the configuration of an existing slot type.
     */
    suspend fun updateSlotType(block: UpdateSlotTypeRequest.Builder.() -> Unit) = updateSlotType(UpdateSlotTypeRequest.Builder().apply(block).build())
}
