// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.lexmodelsv2.model.*
import aws.sdk.kotlin.services.lexmodelsv2.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Lex Models V2"
const val ServiceApiVersion: String = "2020-08-07"
const val SdkVersion: String = "0.16.1-beta"

internal class DefaultLexModelsV2Client(override val config: LexModelsV2Client.Config) : LexModelsV2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
     */
    override suspend fun buildBotLocale(input: BuildBotLocaleRequest): BuildBotLocaleResponse {
        val op = SdkHttpOperation.build<BuildBotLocaleRequest, BuildBotLocaleResponse> {
            serializer = BuildBotLocaleOperationSerializer()
            deserializer = BuildBotLocaleOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "BuildBotLocale"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Lex conversational bot.
     */
    override suspend fun createBot(input: CreateBotRequest): CreateBotResponse {
        val op = SdkHttpOperation.build<CreateBotRequest, CreateBotResponse> {
            serializer = CreateBotOperationSerializer()
            deserializer = CreateBotOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
     *
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     */
    override suspend fun createBotAlias(input: CreateBotAliasRequest): CreateBotAliasResponse {
        val op = SdkHttpOperation.build<CreateBotAliasRequest, CreateBotAliasResponse> {
            serializer = CreateBotAliasOperationSerializer()
            deserializer = CreateBotAliasOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateBotAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
     */
    override suspend fun createBotLocale(input: CreateBotLocaleRequest): CreateBotLocaleResponse {
        val op = SdkHttpOperation.build<CreateBotLocaleRequest, CreateBotLocaleResponse> {
            serializer = CreateBotLocaleOperationSerializer()
            deserializer = CreateBotLocaleOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateBotLocale"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version of the bot based on the `DRAFT` version. If the `DRAFT` version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version.
     *
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     */
    override suspend fun createBotVersion(input: CreateBotVersionRequest): CreateBotVersionResponse {
        val op = SdkHttpOperation.build<CreateBotVersionRequest, CreateBotVersionResponse> {
            serializer = CreateBotVersionOperationSerializer()
            deserializer = CreateBotVersionOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateBotVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
     *
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.
     *
     * For more information about exporting bots, and about the structure of the export archive, see [ Importing and exporting bots ](https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
     */
    override suspend fun createExport(input: CreateExportRequest): CreateExportResponse {
        val op = SdkHttpOperation.build<CreateExportRequest, CreateExportResponse> {
            serializer = CreateExportOperationSerializer()
            deserializer = CreateExportOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CreateExport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an intent.
     *
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an `OrderPizza` intent.
     *
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * + Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.
     * + Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.
     * + How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.
     * + A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * + A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * + A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"
     */
    override suspend fun createIntent(input: CreateIntentRequest): CreateIntentResponse {
        val op = SdkHttpOperation.build<CreateIntentRequest, CreateIntentResponse> {
            serializer = CreateIntentOperationSerializer()
            deserializer = CreateIntentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIntent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new resource policy with the specified policy statements.
     */
    override suspend fun createResourcePolicy(input: CreateResourcePolicyRequest): CreateResourcePolicyResponse {
        val op = SdkHttpOperation.build<CreateResourcePolicyRequest, CreateResourcePolicyResponse> {
            serializer = CreateResourcePolicyOperationSerializer()
            deserializer = CreateResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
     *
     * You can't create a resource policy statement that allows cross-account access.
     */
    override suspend fun createResourcePolicyStatement(input: CreateResourcePolicyStatementRequest): CreateResourcePolicyStatementResponse {
        val op = SdkHttpOperation.build<CreateResourcePolicyStatementRequest, CreateResourcePolicyStatementResponse> {
            serializer = CreateResourcePolicyStatementOperationSerializer()
            deserializer = CreateResourcePolicyStatementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResourcePolicyStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
     */
    override suspend fun createSlot(input: CreateSlotRequest): CreateSlotResponse {
        val op = SdkHttpOperation.build<CreateSlotRequest, CreateSlotResponse> {
            serializer = CreateSlotOperationSerializer()
            deserializer = CreateSlotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSlot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom slot type
     *
     *  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.
     */
    override suspend fun createSlotType(input: CreateSlotTypeRequest): CreateSlotTypeResponse {
        val op = SdkHttpOperation.build<CreateSlotTypeRequest, CreateSlotTypeResponse> {
            serializer = CreateSlotTypeOperationSerializer()
            deserializer = CreateSlotTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSlotType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     */
    override suspend fun createUploadUrl(input: CreateUploadUrlRequest): CreateUploadUrlResponse {
        val op = SdkHttpOperation.build<CreateUploadUrlRequest, CreateUploadUrlResponse> {
            serializer = CreateUploadUrlOperationSerializer()
            deserializer = CreateUploadUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUploadUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the `DeleteBotVersion` operation.
     *
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.
     *
     * If a bot has an alias, the `DeleteBot` operation returns a `ResourceInUseException` exception. If you want to delete the bot and the alias, set the `skipResourceInUseCheck` parameter to `true`.
     */
    override suspend fun deleteBot(input: DeleteBotRequest): DeleteBotResponse {
        val op = SdkHttpOperation.build<DeleteBotRequest, DeleteBotResponse> {
            serializer = DeleteBotOperationSerializer()
            deserializer = DeleteBotOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified bot alias.
     */
    override suspend fun deleteBotAlias(input: DeleteBotAliasRequest): DeleteBotAliasResponse {
        val op = SdkHttpOperation.build<DeleteBotAliasRequest, DeleteBotAliasResponse> {
            serializer = DeleteBotAliasOperationSerializer()
            deserializer = DeleteBotAliasOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteBotAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a locale from a bot.
     *
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     */
    override suspend fun deleteBotLocale(input: DeleteBotLocaleRequest): DeleteBotLocaleResponse {
        val op = SdkHttpOperation.build<DeleteBotLocaleRequest, DeleteBotLocaleResponse> {
            serializer = DeleteBotLocaleOperationSerializer()
            deserializer = DeleteBotLocaleOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteBotLocale"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specific version of a bot. To delete all version of a bot, use the [DeleteBot](https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html) operation.
     */
    override suspend fun deleteBotVersion(input: DeleteBotVersionRequest): DeleteBotVersionResponse {
        val op = SdkHttpOperation.build<DeleteBotVersionRequest, DeleteBotVersionResponse> {
            serializer = DeleteBotVersionOperationSerializer()
            deserializer = DeleteBotVersionOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteBotVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a custom vocabulary from the specified locale in the specified bot.
     */
    override suspend fun deleteCustomVocabulary(input: DeleteCustomVocabularyRequest): DeleteCustomVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteCustomVocabularyRequest, DeleteCustomVocabularyResponse> {
            serializer = DeleteCustomVocabularyOperationSerializer()
            deserializer = DeleteCustomVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteCustomVocabulary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a previous export and the associated files stored in an S3 bucket.
     */
    override suspend fun deleteExport(input: DeleteExportRequest): DeleteExportResponse {
        val op = SdkHttpOperation.build<DeleteExportRequest, DeleteExportResponse> {
            serializer = DeleteExportOperationSerializer()
            deserializer = DeleteExportOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteExport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a previous import and the associated file stored in an S3 bucket.
     */
    override suspend fun deleteImport(input: DeleteImportRequest): DeleteImportResponse {
        val op = SdkHttpOperation.build<DeleteImportRequest, DeleteImportResponse> {
            serializer = DeleteImportOperationSerializer()
            deserializer = DeleteImportOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteImport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified intent.
     *
     * Deleting an intent also deletes the slots associated with the intent.
     */
    override suspend fun deleteIntent(input: DeleteIntentRequest): DeleteIntentResponse {
        val op = SdkHttpOperation.build<DeleteIntentRequest, DeleteIntentResponse> {
            serializer = DeleteIntentOperationSerializer()
            deserializer = DeleteIntentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteIntent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
     */
    override suspend fun deleteResourcePolicyStatement(input: DeleteResourcePolicyStatementRequest): DeleteResourcePolicyStatementResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyStatementRequest, DeleteResourcePolicyStatementResponse> {
            serializer = DeleteResourcePolicyStatementOperationSerializer()
            deserializer = DeleteResourcePolicyStatementOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteResourcePolicyStatement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified slot from an intent.
     */
    override suspend fun deleteSlot(input: DeleteSlotRequest): DeleteSlotResponse {
        val op = SdkHttpOperation.build<DeleteSlotRequest, DeleteSlotResponse> {
            serializer = DeleteSlotOperationSerializer()
            deserializer = DeleteSlotOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteSlot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a slot type from a bot locale.
     *
     * If a slot is using the slot type, Amazon Lex throws a `ResourceInUseException` exception. To avoid the exception, set the `skipResourceInUseCheck` parameter to `true`.
     */
    override suspend fun deleteSlotType(input: DeleteSlotTypeRequest): DeleteSlotTypeResponse {
        val op = SdkHttpOperation.build<DeleteSlotTypeRequest, DeleteSlotTypeResponse> {
            serializer = DeleteSlotTypeOperationSerializer()
            deserializer = DeleteSlotTypeOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteSlotType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes stored utterances.
     *
     * Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the [ListAggregatedUtterances](https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html) operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..
     *
     * Use the `DeleteUtterances` operation to manually delete utterances for a specific session. When you use the `DeleteUtterances` operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the `ListAggregatedUtterances` operation are deleted after 15 days.
     */
    override suspend fun deleteUtterances(input: DeleteUtterancesRequest): DeleteUtterancesResponse {
        val op = SdkHttpOperation.build<DeleteUtterancesRequest, DeleteUtterancesResponse> {
            serializer = DeleteUtterancesOperationSerializer()
            deserializer = DeleteUtterancesOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteUtterances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata information about a bot.
     */
    override suspend fun describeBot(input: DescribeBotRequest): DescribeBotResponse {
        val op = SdkHttpOperation.build<DescribeBotRequest, DescribeBotResponse> {
            serializer = DescribeBotOperationSerializer()
            deserializer = DescribeBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about a specific bot alias.
     */
    override suspend fun describeBotAlias(input: DescribeBotAliasRequest): DescribeBotAliasResponse {
        val op = SdkHttpOperation.build<DescribeBotAliasRequest, DescribeBotAliasResponse> {
            serializer = DescribeBotAliasOperationSerializer()
            deserializer = DescribeBotAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBotAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the settings that a bot has for a specific locale.
     */
    override suspend fun describeBotLocale(input: DescribeBotLocaleRequest): DescribeBotLocaleResponse {
        val op = SdkHttpOperation.build<DescribeBotLocaleRequest, DescribeBotLocaleResponse> {
            serializer = DescribeBotLocaleOperationSerializer()
            deserializer = DescribeBotLocaleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBotLocale"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
     */
    override suspend fun describeBotRecommendation(input: DescribeBotRecommendationRequest): DescribeBotRecommendationResponse {
        val op = SdkHttpOperation.build<DescribeBotRecommendationRequest, DescribeBotRecommendationResponse> {
            serializer = DescribeBotRecommendationOperationSerializer()
            deserializer = DescribeBotRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBotRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata about a version of a bot.
     */
    override suspend fun describeBotVersion(input: DescribeBotVersionRequest): DescribeBotVersionResponse {
        val op = SdkHttpOperation.build<DescribeBotVersionRequest, DescribeBotVersionResponse> {
            serializer = DescribeBotVersionOperationSerializer()
            deserializer = DescribeBotVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBotVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides metadata information about a custom vocabulary.
     */
    override suspend fun describeCustomVocabularyMetadata(input: DescribeCustomVocabularyMetadataRequest): DescribeCustomVocabularyMetadataResponse {
        val op = SdkHttpOperation.build<DescribeCustomVocabularyMetadataRequest, DescribeCustomVocabularyMetadataResponse> {
            serializer = DescribeCustomVocabularyMetadataOperationSerializer()
            deserializer = DescribeCustomVocabularyMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomVocabularyMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specific export.
     */
    override suspend fun describeExport(input: DescribeExportRequest): DescribeExportResponse {
        val op = SdkHttpOperation.build<DescribeExportRequest, DescribeExportResponse> {
            serializer = DescribeExportOperationSerializer()
            deserializer = DescribeExportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specific import.
     */
    override suspend fun describeImport(input: DescribeImportRequest): DescribeImportResponse {
        val op = SdkHttpOperation.build<DescribeImportRequest, DescribeImportResponse> {
            serializer = DescribeImportOperationSerializer()
            deserializer = DescribeImportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about an intent.
     */
    override suspend fun describeIntent(input: DescribeIntentRequest): DescribeIntentResponse {
        val op = SdkHttpOperation.build<DescribeIntentRequest, DescribeIntentResponse> {
            serializer = DescribeIntentOperationSerializer()
            deserializer = DescribeIntentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIntent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the resource policy and policy revision for a bot or bot alias.
     */
    override suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse {
        val op = SdkHttpOperation.build<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse> {
            serializer = DescribeResourcePolicyOperationSerializer()
            deserializer = DescribeResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about a slot.
     */
    override suspend fun describeSlot(input: DescribeSlotRequest): DescribeSlotResponse {
        val op = SdkHttpOperation.build<DescribeSlotRequest, DescribeSlotResponse> {
            serializer = DescribeSlotOperationSerializer()
            deserializer = DescribeSlotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSlot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets metadata information about a slot type.
     */
    override suspend fun describeSlotType(input: DescribeSlotTypeRequest): DescribeSlotTypeResponse {
        val op = SdkHttpOperation.build<DescribeSlotTypeRequest, DescribeSlotTypeResponse> {
            serializer = DescribeSlotTypeOperationSerializer()
            deserializer = DescribeSlotTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSlotType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of utterances that users have sent to the bot.
     *
     * Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.
     *
     * You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.
     *
     * Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.
     *
     * Utterances statistics are not generated under the following conditions:
     * + The `childDirected` field was set to true when the bot was created.
     * + You are using slot obfuscation with one or more slots.
     * + You opted out of participating in improving Amazon Lex.
     */
    override suspend fun listAggregatedUtterances(input: ListAggregatedUtterancesRequest): ListAggregatedUtterancesResponse {
        val op = SdkHttpOperation.build<ListAggregatedUtterancesRequest, ListAggregatedUtterancesResponse> {
            serializer = ListAggregatedUtterancesOperationSerializer()
            deserializer = ListAggregatedUtterancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAggregatedUtterances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of aliases for the specified bot.
     */
    override suspend fun listBotAliases(input: ListBotAliasesRequest): ListBotAliasesResponse {
        val op = SdkHttpOperation.build<ListBotAliasesRequest, ListBotAliasesResponse> {
            serializer = ListBotAliasesOperationSerializer()
            deserializer = ListBotAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBotAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of locales for the specified bot.
     */
    override suspend fun listBotLocales(input: ListBotLocalesRequest): ListBotLocalesResponse {
        val op = SdkHttpOperation.build<ListBotLocalesRequest, ListBotLocalesResponse> {
            serializer = ListBotLocalesOperationSerializer()
            deserializer = ListBotLocalesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBotLocales"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of bot recommendations that meet the specified criteria.
     */
    override suspend fun listBotRecommendations(input: ListBotRecommendationsRequest): ListBotRecommendationsResponse {
        val op = SdkHttpOperation.build<ListBotRecommendationsRequest, ListBotRecommendationsResponse> {
            serializer = ListBotRecommendationsOperationSerializer()
            deserializer = ListBotRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBotRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about all of the versions of a bot.
     *
     * The `ListBotVersions` operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the `ListBotVersions` operation returns for summaries, one for each numbered version and one for the `DRAFT` version.
     *
     * The `ListBotVersions` operation always returns at least one version, the `DRAFT` version.
     */
    override suspend fun listBotVersions(input: ListBotVersionsRequest): ListBotVersionsResponse {
        val op = SdkHttpOperation.build<ListBotVersionsRequest, ListBotVersionsResponse> {
            serializer = ListBotVersionsOperationSerializer()
            deserializer = ListBotVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBotVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of available bots.
     */
    override suspend fun listBots(input: ListBotsRequest): ListBotsResponse {
        val op = SdkHttpOperation.build<ListBotsRequest, ListBotsResponse> {
            serializer = ListBotsOperationSerializer()
            deserializer = ListBotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     *
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the `parentIntentSignature` parameter when you call the `CreateIntent` operation. For more information, see [CreateIntent](https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html).
     */
    override suspend fun listBuiltInIntents(input: ListBuiltInIntentsRequest): ListBuiltInIntentsResponse {
        val op = SdkHttpOperation.build<ListBuiltInIntentsRequest, ListBuiltInIntentsResponse> {
            serializer = ListBuiltInIntentsOperationSerializer()
            deserializer = ListBuiltInIntentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBuiltInIntents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of built-in slot types that meet the specified criteria.
     */
    override suspend fun listBuiltInSlotTypes(input: ListBuiltInSlotTypesRequest): ListBuiltInSlotTypesResponse {
        val op = SdkHttpOperation.build<ListBuiltInSlotTypesRequest, ListBuiltInSlotTypesResponse> {
            serializer = ListBuiltInSlotTypesOperationSerializer()
            deserializer = ListBuiltInSlotTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBuiltInSlotTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
     */
    override suspend fun listExports(input: ListExportsRequest): ListExportsResponse {
        val op = SdkHttpOperation.build<ListExportsRequest, ListExportsResponse> {
            serializer = ListExportsOperationSerializer()
            deserializer = ListExportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
     */
    override suspend fun listImports(input: ListImportsRequest): ListImportsResponse {
        val op = SdkHttpOperation.build<ListImportsRequest, ListImportsResponse> {
            serializer = ListImportsOperationSerializer()
            deserializer = ListImportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListImports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of intents that meet the specified criteria.
     */
    override suspend fun listIntents(input: ListIntentsRequest): ListIntentsResponse {
        val op = SdkHttpOperation.build<ListIntentsRequest, ListIntentsResponse> {
            serializer = ListIntentsOperationSerializer()
            deserializer = ListIntentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIntents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of recommended intents provided by the bot recommendation that you can use in your bot.
     */
    override suspend fun listRecommendedIntents(input: ListRecommendedIntentsRequest): ListRecommendedIntentsResponse {
        val op = SdkHttpOperation.build<ListRecommendedIntentsRequest, ListRecommendedIntentsResponse> {
            serializer = ListRecommendedIntentsOperationSerializer()
            deserializer = ListRecommendedIntentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecommendedIntents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of slot types that match the specified criteria.
     */
    override suspend fun listSlotTypes(input: ListSlotTypesRequest): ListSlotTypesResponse {
        val op = SdkHttpOperation.build<ListSlotTypesRequest, ListSlotTypesResponse> {
            serializer = ListSlotTypesOperationSerializer()
            deserializer = ListSlotTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSlotTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of slots that match the specified criteria.
     */
    override suspend fun listSlots(input: ListSlotsRequest): ListSlotsResponse {
        val op = SdkHttpOperation.build<ListSlotsRequest, ListSlotsResponse> {
            serializer = ListSlotsOperationSerializer()
            deserializer = ListSlotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSlots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Search for associated transcripts that meet the specified criteria.
     */
    override suspend fun searchAssociatedTranscripts(input: SearchAssociatedTranscriptsRequest): SearchAssociatedTranscriptsResponse {
        val op = SdkHttpOperation.build<SearchAssociatedTranscriptsRequest, SearchAssociatedTranscriptsResponse> {
            serializer = SearchAssociatedTranscriptsOperationSerializer()
            deserializer = SearchAssociatedTranscriptsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchAssociatedTranscripts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this to provide your transcript data, and to start the bot recommendation process.
     */
    override suspend fun startBotRecommendation(input: StartBotRecommendationRequest): StartBotRecommendationResponse {
        val op = SdkHttpOperation.build<StartBotRecommendationRequest, StartBotRecommendationResponse> {
            serializer = StartBotRecommendationOperationSerializer()
            deserializer = StartBotRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StartBotRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
     */
    override suspend fun startImport(input: StartImportRequest): StartImportResponse {
        val op = SdkHttpOperation.build<StartImportRequest, StartImportResponse> {
            serializer = StartImportOperationSerializer()
            deserializer = StartImportOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StartImport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a bot, bot alias, or bot channel.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing bot.
     */
    override suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse {
        val op = SdkHttpOperation.build<UpdateBotRequest, UpdateBotResponse> {
            serializer = UpdateBotOperationSerializer()
            deserializer = UpdateBotOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing bot alias.
     */
    override suspend fun updateBotAlias(input: UpdateBotAliasRequest): UpdateBotAliasResponse {
        val op = SdkHttpOperation.build<UpdateBotAliasRequest, UpdateBotAliasResponse> {
            serializer = UpdateBotAliasOperationSerializer()
            deserializer = UpdateBotAliasOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateBotAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings that a bot has for a specific locale.
     */
    override suspend fun updateBotLocale(input: UpdateBotLocaleRequest): UpdateBotLocaleResponse {
        val op = SdkHttpOperation.build<UpdateBotLocaleRequest, UpdateBotLocaleResponse> {
            serializer = UpdateBotLocaleOperationSerializer()
            deserializer = UpdateBotLocaleOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateBotLocale"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing bot recommendation request.
     */
    override suspend fun updateBotRecommendation(input: UpdateBotRecommendationRequest): UpdateBotRecommendationResponse {
        val op = SdkHttpOperation.build<UpdateBotRecommendationRequest, UpdateBotRecommendationResponse> {
            serializer = UpdateBotRecommendationOperationSerializer()
            deserializer = UpdateBotRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateBotRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the password used to protect an export zip archive.
     *
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the [DescribeExport](https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html) operation.
     */
    override suspend fun updateExport(input: UpdateExportRequest): UpdateExportResponse {
        val op = SdkHttpOperation.build<UpdateExportRequest, UpdateExportResponse> {
            serializer = UpdateExportOperationSerializer()
            deserializer = UpdateExportOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateExport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for an intent.
     */
    override suspend fun updateIntent(input: UpdateIntentRequest): UpdateIntentResponse {
        val op = SdkHttpOperation.build<UpdateIntentRequest, UpdateIntentResponse> {
            serializer = UpdateIntentOperationSerializer()
            deserializer = UpdateIntentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIntent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
     */
    override suspend fun updateResourcePolicy(input: UpdateResourcePolicyRequest): UpdateResourcePolicyResponse {
        val op = SdkHttpOperation.build<UpdateResourcePolicyRequest, UpdateResourcePolicyResponse> {
            serializer = UpdateResourcePolicyOperationSerializer()
            deserializer = UpdateResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for a slot.
     */
    override suspend fun updateSlot(input: UpdateSlotRequest): UpdateSlotResponse {
        val op = SdkHttpOperation.build<UpdateSlotRequest, UpdateSlotResponse> {
            serializer = UpdateSlotOperationSerializer()
            deserializer = UpdateSlotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSlot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing slot type.
     */
    override suspend fun updateSlotType(input: UpdateSlotTypeRequest): UpdateSlotTypeResponse {
        val op = SdkHttpOperation.build<UpdateSlotTypeRequest, UpdateSlotTypeResponse> {
            serializer = UpdateSlotTypeOperationSerializer()
            deserializer = UpdateSlotTypeOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateSlotType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "lex"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "lex")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
