// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetModality
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateTestSetResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateTestSetOperationDeserializer: HttpDeserializer.NonStreaming<UpdateTestSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateTestSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateTestSetError(context, call, payload)
        }
        val builder = UpdateTestSetResponse.Builder()

        if (payload != null) {
            deserializeUpdateTestSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateTestSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateTestSetOperationBody(builder: UpdateTestSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val MODALITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("modality"))
    val NUMTURNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("numTurns"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STORAGELOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("storageLocation"))
    val TESTSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetId"))
    val TESTSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(MODALITY_DESCRIPTOR)
        field(NUMTURNS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STORAGELOCATION_DESCRIPTOR)
        field(TESTSETID_DESCRIPTOR)
        field(TESTSETNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MODALITY_DESCRIPTOR.index -> builder.modality = deserializeString().let { TestSetModality.fromValue(it) }
                NUMTURNS_DESCRIPTOR.index -> builder.numTurns = deserializeInt()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TestSetStatus.fromValue(it) }
                STORAGELOCATION_DESCRIPTOR.index -> builder.storageLocation = deserializeTestSetStorageLocationDocument(deserializer)
                TESTSETID_DESCRIPTOR.index -> builder.testSetId = deserializeString()
                TESTSETNAME_DESCRIPTOR.index -> builder.testSetName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
