// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsUtteranceFilter
import aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceDataSortBy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListUtteranceAnalyticsDataOperationSerializer: HttpSerializer.NonStreaming<ListUtteranceAnalyticsDataRequest> {
    override fun serialize(context: ExecutionContext, input: ListUtteranceAnalyticsDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.botId) { "botId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bots"))
                add(PercentEncoding.SmithyLabel.encode(input.botId))
                add(PercentEncoding.Path.encode("analytics"))
                add(PercentEncoding.Path.encode("utterances"))
            }
        }

        val payload = serializeListUtteranceAnalyticsDataOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListUtteranceAnalyticsDataOperationBody(context: ExecutionContext, input: ListUtteranceAnalyticsDataRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endDateTime"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SORTBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sortBy"))
    val STARTDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDDATETIME_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SORTBY_DESCRIPTOR)
        field(STARTDATETIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.endDateTime?.let { field(ENDDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsUtteranceFilterDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.sortBy?.let { field(SORTBY_DESCRIPTOR, it, ::serializeUtteranceDataSortByDocument) }
        input.startDateTime?.let { field(STARTDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
