// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsBinBySpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageFilter
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageGroupBySpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.AnalyticsIntentStageMetric
import aws.sdk.kotlin.services.lexmodelsv2.model.ListIntentStageMetricsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListIntentStageMetricsOperationSerializer: HttpSerializer.NonStreaming<ListIntentStageMetricsRequest> {
    override fun serialize(context: ExecutionContext, input: ListIntentStageMetricsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.botId) { "botId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bots"))
                add(PercentEncoding.SmithyLabel.encode(input.botId))
                add(PercentEncoding.Path.encode("analytics"))
                add(PercentEncoding.Path.encode("intentstagemetrics"))
            }
        }

        val payload = serializeListIntentStageMetricsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListIntentStageMetricsOperationBody(context: ExecutionContext, input: ListIntentStageMetricsRequest): ByteArray {
    val serializer = JsonSerializer()
    val BINBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("binBy"))
    val ENDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endDateTime"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filters"))
    val GROUPBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("groupBy"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("metrics"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val STARTDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BINBY_DESCRIPTOR)
        field(ENDDATETIME_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(GROUPBY_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STARTDATETIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.binBy != null) {
            listField(BINBY_DESCRIPTOR) {
                for (el0 in input.binBy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsBinBySpecificationDocument))
                }
            }
        }
        input.endDateTime?.let { field(ENDDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsIntentStageFilterDocument))
                }
            }
        }
        if (input.groupBy != null) {
            listField(GROUPBY_DESCRIPTOR) {
                for (el0 in input.groupBy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsIntentStageGroupBySpecificationDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        if (input.metrics != null) {
            listField(METRICS_DESCRIPTOR) {
                for (el0 in input.metrics) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAnalyticsIntentStageMetricDocument))
                }
            }
        }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.startDateTime?.let { field(STARTDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
