// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeTestSetDiscrepancyReportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetDiscrepancyErrors
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget
import aws.sdk.kotlin.services.lexmodelsv2.model.TestSetDiscrepancyReportStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeTestSetDiscrepancyReportOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTestSetDiscrepancyReportResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTestSetDiscrepancyReportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTestSetDiscrepancyReportError(context, call, payload)
        }
        val builder = DescribeTestSetDiscrepancyReportResponse.Builder()

        if (payload != null) {
            deserializeDescribeTestSetDiscrepancyReportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTestSetDiscrepancyReportError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTestSetDiscrepancyReportOperationBody(builder: DescribeTestSetDiscrepancyReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val LASTUPDATEDDATATIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDataTime"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("target"))
    val TESTSETDISCREPANCYRAWOUTPUTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetDiscrepancyRawOutputUrl"))
    val TESTSETDISCREPANCYREPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetDiscrepancyReportId"))
    val TESTSETDISCREPANCYREPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("testSetDiscrepancyReportStatus"))
    val TESTSETDISCREPANCYTOPERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("testSetDiscrepancyTopErrors"))
    val TESTSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATETIME_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(LASTUPDATEDDATATIME_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
        field(TESTSETDISCREPANCYRAWOUTPUTURL_DESCRIPTOR)
        field(TESTSETDISCREPANCYREPORTID_DESCRIPTOR)
        field(TESTSETDISCREPANCYREPORTSTATUS_DESCRIPTOR)
        field(TESTSETDISCREPANCYTOPERRORS_DESCRIPTOR)
        field(TESTSETID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTUPDATEDDATATIME_DESCRIPTOR.index -> builder.lastUpdatedDataTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                TARGET_DESCRIPTOR.index -> builder.target = deserializeTestSetDiscrepancyReportResourceTargetDocument(deserializer)
                TESTSETDISCREPANCYRAWOUTPUTURL_DESCRIPTOR.index -> builder.testSetDiscrepancyRawOutputUrl = deserializeString()
                TESTSETDISCREPANCYREPORTID_DESCRIPTOR.index -> builder.testSetDiscrepancyReportId = deserializeString()
                TESTSETDISCREPANCYREPORTSTATUS_DESCRIPTOR.index -> builder.testSetDiscrepancyReportStatus = deserializeString().let { TestSetDiscrepancyReportStatus.fromValue(it) }
                TESTSETDISCREPANCYTOPERRORS_DESCRIPTOR.index -> builder.testSetDiscrepancyTopErrors = deserializeTestSetDiscrepancyErrorsDocument(deserializer)
                TESTSETID_DESCRIPTOR.index -> builder.testSetId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
