// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeIntentResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.InitialResponseSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.InputContext
import aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.OutputContext
import aws.sdk.kotlin.services.lexmodelsv2.model.QInConnectIntentConfiguration
import aws.sdk.kotlin.services.lexmodelsv2.model.QnAIntentConfiguration
import aws.sdk.kotlin.services.lexmodelsv2.model.SampleUtterance
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotPriority
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeIntentOperationDeserializer: HttpDeserializer.NonStreaming<DescribeIntentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeIntentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeIntentError(context, call, payload)
        }
        val builder = DescribeIntentResponse.Builder()

        if (payload != null) {
            deserializeDescribeIntentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeIntentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeIntentOperationBody(builder: DescribeIntentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DIALOGCODEHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dialogCodeHook"))
    val FULFILLMENTCODEHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("fulfillmentCodeHook"))
    val INITIALRESPONSESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("initialResponseSetting"))
    val INPUTCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputContexts"))
    val INTENTCLOSINGSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("intentClosingSetting"))
    val INTENTCONFIRMATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("intentConfirmationSetting"))
    val INTENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentId"))
    val INTENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentName"))
    val KENDRACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kendraConfiguration"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val OUTPUTCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputContexts"))
    val PARENTINTENTSIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentIntentSignature"))
    val QINCONNECTINTENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("qInConnectIntentConfiguration"))
    val QNAINTENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("qnAIntentConfiguration"))
    val SAMPLEUTTERANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sampleUtterances"))
    val SLOTPRIORITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("slotPriorities"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DIALOGCODEHOOK_DESCRIPTOR)
        field(FULFILLMENTCODEHOOK_DESCRIPTOR)
        field(INITIALRESPONSESETTING_DESCRIPTOR)
        field(INPUTCONTEXTS_DESCRIPTOR)
        field(INTENTCLOSINGSETTING_DESCRIPTOR)
        field(INTENTCONFIRMATIONSETTING_DESCRIPTOR)
        field(INTENTID_DESCRIPTOR)
        field(INTENTNAME_DESCRIPTOR)
        field(KENDRACONFIGURATION_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(OUTPUTCONTEXTS_DESCRIPTOR)
        field(PARENTINTENTSIGNATURE_DESCRIPTOR)
        field(QINCONNECTINTENTCONFIGURATION_DESCRIPTOR)
        field(QNAINTENTCONFIGURATION_DESCRIPTOR)
        field(SAMPLEUTTERANCES_DESCRIPTOR)
        field(SLOTPRIORITIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DIALOGCODEHOOK_DESCRIPTOR.index -> builder.dialogCodeHook = deserializeDialogCodeHookSettingsDocument(deserializer)
                FULFILLMENTCODEHOOK_DESCRIPTOR.index -> builder.fulfillmentCodeHook = deserializeFulfillmentCodeHookSettingsDocument(deserializer)
                INITIALRESPONSESETTING_DESCRIPTOR.index -> builder.initialResponseSetting = deserializeInitialResponseSettingDocument(deserializer)
                INPUTCONTEXTS_DESCRIPTOR.index -> builder.inputContexts =
                    deserializer.deserializeList(INPUTCONTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<InputContext>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInputContextDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INTENTCLOSINGSETTING_DESCRIPTOR.index -> builder.intentClosingSetting = deserializeIntentClosingSettingDocument(deserializer)
                INTENTCONFIRMATIONSETTING_DESCRIPTOR.index -> builder.intentConfirmationSetting = deserializeIntentConfirmationSettingDocument(deserializer)
                INTENTID_DESCRIPTOR.index -> builder.intentId = deserializeString()
                INTENTNAME_DESCRIPTOR.index -> builder.intentName = deserializeString()
                KENDRACONFIGURATION_DESCRIPTOR.index -> builder.kendraConfiguration = deserializeKendraConfigurationDocument(deserializer)
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                OUTPUTCONTEXTS_DESCRIPTOR.index -> builder.outputContexts =
                    deserializer.deserializeList(OUTPUTCONTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<OutputContext>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOutputContextDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARENTINTENTSIGNATURE_DESCRIPTOR.index -> builder.parentIntentSignature = deserializeString()
                QINCONNECTINTENTCONFIGURATION_DESCRIPTOR.index -> builder.qInConnectIntentConfiguration = deserializeQInConnectIntentConfigurationDocument(deserializer)
                QNAINTENTCONFIGURATION_DESCRIPTOR.index -> builder.qnAIntentConfiguration = deserializeQnAIntentConfigurationDocument(deserializer)
                SAMPLEUTTERANCES_DESCRIPTOR.index -> builder.sampleUtterances =
                    deserializer.deserializeList(SAMPLEUTTERANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<SampleUtterance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSampleUtteranceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SLOTPRIORITIES_DESCRIPTOR.index -> builder.slotPriorities =
                    deserializer.deserializeList(SLOTPRIORITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<SlotPriority>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSlotPriorityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
