// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeImportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ImportResourceSpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.ImportStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.MergeStrategy
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeImportOperationDeserializer: HttpDeserializer.NonStreaming<DescribeImportResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeImportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeImportError(context, call, payload)
        }
        val builder = DescribeImportResponse.Builder()

        if (payload != null) {
            deserializeDescribeImportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeImportError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImportOperationBody(builder: DescribeImportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val IMPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importId"))
    val IMPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("importStatus"))
    val IMPORTEDRESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedResourceId"))
    val IMPORTEDRESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedResourceName"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val MERGESTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("mergeStrategy"))
    val RESOURCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATETIME_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(IMPORTID_DESCRIPTOR)
        field(IMPORTSTATUS_DESCRIPTOR)
        field(IMPORTEDRESOURCEID_DESCRIPTOR)
        field(IMPORTEDRESOURCENAME_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(MERGESTRATEGY_DESCRIPTOR)
        field(RESOURCESPECIFICATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMPORTID_DESCRIPTOR.index -> builder.importId = deserializeString()
                IMPORTSTATUS_DESCRIPTOR.index -> builder.importStatus = deserializeString().let { ImportStatus.fromValue(it) }
                IMPORTEDRESOURCEID_DESCRIPTOR.index -> builder.importedResourceId = deserializeString()
                IMPORTEDRESOURCENAME_DESCRIPTOR.index -> builder.importedResourceName = deserializeString()
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MERGESTRATEGY_DESCRIPTOR.index -> builder.mergeStrategy = deserializeString().let { MergeStrategy.fromValue(it) }
                RESOURCESPECIFICATION_DESCRIPTOR.index -> builder.resourceSpecification = deserializeImportResourceSpecificationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
