// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.BotMember
import aws.sdk.kotlin.services.lexmodelsv2.model.BotStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.BotType
import aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotVersionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.ParentBotNetwork
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeBotVersionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBotVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBotVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBotVersionError(context, call, payload)
        }
        val builder = DescribeBotVersionResponse.Builder()

        if (payload != null) {
            deserializeDescribeBotVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBotVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBotVersionOperationBody(builder: DescribeBotVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("botMembers"))
    val BOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botName"))
    val BOTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("botStatus"))
    val BOTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("botType"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DATAPRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataPrivacy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val IDLESESSIONTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("idleSessionTTLInSeconds"))
    val PARENTBOTNETWORKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parentBotNetworks"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTMEMBERS_DESCRIPTOR)
        field(BOTNAME_DESCRIPTOR)
        field(BOTSTATUS_DESCRIPTOR)
        field(BOTTYPE_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DATAPRIVACY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(IDLESESSIONTTLINSECONDS_DESCRIPTOR)
        field(PARENTBOTNETWORKS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTMEMBERS_DESCRIPTOR.index -> builder.botMembers =
                    deserializer.deserializeList(BOTMEMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<BotMember>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBotMemberDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOTNAME_DESCRIPTOR.index -> builder.botName = deserializeString()
                BOTSTATUS_DESCRIPTOR.index -> builder.botStatus = deserializeString().let { BotStatus.fromValue(it) }
                BOTTYPE_DESCRIPTOR.index -> builder.botType = deserializeString().let { BotType.fromValue(it) }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATAPRIVACY_DESCRIPTOR.index -> builder.dataPrivacy = deserializeDataPrivacyDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IDLESESSIONTTLINSECONDS_DESCRIPTOR.index -> builder.idleSessionTtlInSeconds = deserializeInt()
                PARENTBOTNETWORKS_DESCRIPTOR.index -> builder.parentBotNetworks =
                    deserializer.deserializeList(PARENTBOTNETWORKS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParentBotNetwork>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParentBotNetworkDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
