// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleHistoryEvent
import aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.GenerativeAiSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeBotLocaleOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBotLocaleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBotLocaleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBotLocaleError(context, call, payload)
        }
        val builder = DescribeBotLocaleResponse.Builder()

        if (payload != null) {
            deserializeDescribeBotLocaleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBotLocaleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBotLocaleOperationBody(builder: DescribeBotLocaleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTLOCALEHISTORYEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("botLocaleHistoryEvents"))
    val BOTLOCALESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("botLocaleStatus"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val GENERATIVEAISETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("generativeAISettings"))
    val INTENTSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("intentsCount"))
    val LASTBUILDSUBMITTEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastBuildSubmittedDateTime"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val LOCALENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeName"))
    val NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("nluIntentConfidenceThreshold"))
    val RECOMMENDEDACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("recommendedActions"))
    val SLOTTYPESCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("slotTypesCount"))
    val VOICESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("voiceSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTLOCALEHISTORYEVENTS_DESCRIPTOR)
        field(BOTLOCALESTATUS_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(GENERATIVEAISETTINGS_DESCRIPTOR)
        field(INTENTSCOUNT_DESCRIPTOR)
        field(LASTBUILDSUBMITTEDDATETIME_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(LOCALENAME_DESCRIPTOR)
        field(NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR)
        field(RECOMMENDEDACTIONS_DESCRIPTOR)
        field(SLOTTYPESCOUNT_DESCRIPTOR)
        field(VOICESETTINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTLOCALEHISTORYEVENTS_DESCRIPTOR.index -> builder.botLocaleHistoryEvents =
                    deserializer.deserializeList(BOTLOCALEHISTORYEVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BotLocaleHistoryEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBotLocaleHistoryEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOTLOCALESTATUS_DESCRIPTOR.index -> builder.botLocaleStatus = deserializeString().let { BotLocaleStatus.fromValue(it) }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GENERATIVEAISETTINGS_DESCRIPTOR.index -> builder.generativeAiSettings = deserializeGenerativeAiSettingsDocument(deserializer)
                INTENTSCOUNT_DESCRIPTOR.index -> builder.intentsCount = deserializeInt()
                LASTBUILDSUBMITTEDDATETIME_DESCRIPTOR.index -> builder.lastBuildSubmittedDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                LOCALENAME_DESCRIPTOR.index -> builder.localeName = deserializeString()
                NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR.index -> builder.nluIntentConfidenceThreshold = deserializeDouble()
                RECOMMENDEDACTIONS_DESCRIPTOR.index -> builder.recommendedActions =
                    deserializer.deserializeList(RECOMMENDEDACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SLOTTYPESCOUNT_DESCRIPTOR.index -> builder.slotTypesCount = deserializeInt()
                VOICESETTINGS_DESCRIPTOR.index -> builder.voiceSettings = deserializeVoiceSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
