// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.BotAliasHistoryEvent
import aws.sdk.kotlin.services.lexmodelsv2.model.BotAliasLocaleSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.BotAliasStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.ParentBotNetwork
import aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeBotAliasOperationDeserializer: HttpDeserializer.NonStreaming<DescribeBotAliasResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeBotAliasResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBotAliasError(context, call, payload)
        }
        val builder = DescribeBotAliasResponse.Builder()

        if (payload != null) {
            deserializeDescribeBotAliasOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeBotAliasError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBotAliasOperationBody(builder: DescribeBotAliasResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTALIASHISTORYEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("botAliasHistoryEvents"))
    val BOTALIASID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasId"))
    val BOTALIASLOCALESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("botAliasLocaleSettings"))
    val BOTALIASNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasName"))
    val BOTALIASSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("botAliasStatus"))
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CONVERSATIONLOGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("conversationLogSettings"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val PARENTBOTNETWORKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parentBotNetworks"))
    val SENTIMENTANALYSISSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sentimentAnalysisSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTALIASHISTORYEVENTS_DESCRIPTOR)
        field(BOTALIASID_DESCRIPTOR)
        field(BOTALIASLOCALESETTINGS_DESCRIPTOR)
        field(BOTALIASNAME_DESCRIPTOR)
        field(BOTALIASSTATUS_DESCRIPTOR)
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CONVERSATIONLOGSETTINGS_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(PARENTBOTNETWORKS_DESCRIPTOR)
        field(SENTIMENTANALYSISSETTINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTALIASHISTORYEVENTS_DESCRIPTOR.index -> builder.botAliasHistoryEvents =
                    deserializer.deserializeList(BOTALIASHISTORYEVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BotAliasHistoryEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBotAliasHistoryEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOTALIASID_DESCRIPTOR.index -> builder.botAliasId = deserializeString()
                BOTALIASLOCALESETTINGS_DESCRIPTOR.index -> builder.botAliasLocaleSettings =
                    deserializer.deserializeMap(BOTALIASLOCALESETTINGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, BotAliasLocaleSettings>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBotAliasLocaleSettingsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BOTALIASNAME_DESCRIPTOR.index -> builder.botAliasName = deserializeString()
                BOTALIASSTATUS_DESCRIPTOR.index -> builder.botAliasStatus = deserializeString().let { BotAliasStatus.fromValue(it) }
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CONVERSATIONLOGSETTINGS_DESCRIPTOR.index -> builder.conversationLogSettings = deserializeConversationLogSettingsDocument(deserializer)
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                PARENTBOTNETWORKS_DESCRIPTOR.index -> builder.parentBotNetworks =
                    deserializer.deserializeList(PARENTBOTNETWORKS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParentBotNetwork>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParentBotNetworkDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SENTIMENTANALYSISSETTINGS_DESCRIPTOR.index -> builder.sentimentAnalysisSettings = deserializeSentimentAnalysisSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
