// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.CompositeSlotTypeSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeValue
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class CreateSlotTypeOperationDeserializer: HttpDeserializer.NonStreaming<CreateSlotTypeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateSlotTypeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateSlotTypeError(context, call, payload)
        }
        val builder = CreateSlotTypeResponse.Builder()

        if (payload != null) {
            deserializeCreateSlotTypeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateSlotTypeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSlotTypeOperationBody(builder: CreateSlotTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val COMPOSITESLOTTYPESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("compositeSlotTypeSetting"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXTERNALSOURCESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("externalSourceSetting"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val PARENTSLOTTYPESIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentSlotTypeSignature"))
    val SLOTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeId"))
    val SLOTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeName"))
    val SLOTTYPEVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("slotTypeValues"))
    val VALUESELECTIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("valueSelectionSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(COMPOSITESLOTTYPESETTING_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXTERNALSOURCESETTING_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(PARENTSLOTTYPESIGNATURE_DESCRIPTOR)
        field(SLOTTYPEID_DESCRIPTOR)
        field(SLOTTYPENAME_DESCRIPTOR)
        field(SLOTTYPEVALUES_DESCRIPTOR)
        field(VALUESELECTIONSETTING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                COMPOSITESLOTTYPESETTING_DESCRIPTOR.index -> builder.compositeSlotTypeSetting = deserializeCompositeSlotTypeSettingDocument(deserializer)
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXTERNALSOURCESETTING_DESCRIPTOR.index -> builder.externalSourceSetting = deserializeExternalSourceSettingDocument(deserializer)
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                PARENTSLOTTYPESIGNATURE_DESCRIPTOR.index -> builder.parentSlotTypeSignature = deserializeString()
                SLOTTYPEID_DESCRIPTOR.index -> builder.slotTypeId = deserializeString()
                SLOTTYPENAME_DESCRIPTOR.index -> builder.slotTypeName = deserializeString()
                SLOTTYPEVALUES_DESCRIPTOR.index -> builder.slotTypeValues =
                    deserializer.deserializeList(SLOTTYPEVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<SlotTypeValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSlotTypeValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALUESELECTIONSETTING_DESCRIPTOR.index -> builder.valueSelectionSetting = deserializeSlotValueSelectionSettingDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
