// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateSlotOperationSerializer: HttpSerializer.NonStreaming<CreateSlotRequest> {
    override fun serialize(context: ExecutionContext, input: CreateSlotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.botId) { "botId is bound to the URI and must not be null" }
            requireNotNull(input.botVersion) { "botVersion is bound to the URI and must not be null" }
            requireNotNull(input.localeId) { "localeId is bound to the URI and must not be null" }
            requireNotNull(input.intentId) { "intentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bots"))
                add(PercentEncoding.SmithyLabel.encode(input.botId))
                add(PercentEncoding.Path.encode("botversions"))
                add(PercentEncoding.SmithyLabel.encode(input.botVersion))
                add(PercentEncoding.Path.encode("botlocales"))
                add(PercentEncoding.SmithyLabel.encode(input.localeId))
                add(PercentEncoding.Path.encode("intents"))
                add(PercentEncoding.SmithyLabel.encode(input.intentId))
                add(PercentEncoding.Path.encode("slots"))
            }
        }

        val payload = serializeCreateSlotOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateSlotOperationBody(context: ExecutionContext, input: CreateSlotRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MULTIPLEVALUESSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multipleValuesSetting"))
    val OBFUSCATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("obfuscationSetting"))
    val SLOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotName"))
    val SLOTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeId"))
    val SUBSLOTSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subSlotSetting"))
    val VALUEELICITATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("valueElicitationSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(MULTIPLEVALUESSETTING_DESCRIPTOR)
        field(OBFUSCATIONSETTING_DESCRIPTOR)
        field(SLOTNAME_DESCRIPTOR)
        field(SLOTTYPEID_DESCRIPTOR)
        field(SUBSLOTSETTING_DESCRIPTOR)
        field(VALUEELICITATIONSETTING_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.multipleValuesSetting?.let { field(MULTIPLEVALUESSETTING_DESCRIPTOR, it, ::serializeMultipleValuesSettingDocument) }
        input.obfuscationSetting?.let { field(OBFUSCATIONSETTING_DESCRIPTOR, it, ::serializeObfuscationSettingDocument) }
        input.slotName?.let { field(SLOTNAME_DESCRIPTOR, it) }
        input.slotTypeId?.let { field(SLOTTYPEID_DESCRIPTOR, it) }
        input.subSlotSetting?.let { field(SUBSLOTSETTING_DESCRIPTOR, it, ::serializeSubSlotSettingDocument) }
        input.valueElicitationSetting?.let { field(VALUEELICITATIONSETTING_DESCRIPTOR, it, ::serializeSlotValueElicitationSettingDocument) }
    }
    return serializer.toByteArray()
}
