// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateSlotRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the bot that contains the slot.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot that contains the slot. Must always be `DRAFT`.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * The new description for the slot.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the intent that contains the slot.
     */
    public val intentId: kotlin.String? = builder.intentId
    /**
     * The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to `true` in any other locale, Amazon Lex throws a `ValidationException`.
     *
     * If the `multipleValuesSetting` is not set, the default value is `false`.
     */
    public val multipleValuesSetting: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting? = builder.multipleValuesSetting
    /**
     * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
     */
    public val obfuscationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting? = builder.obfuscationSetting
    /**
     * The unique identifier for the slot to update.
     */
    public val slotId: kotlin.String? = builder.slotId
    /**
     * The new name for the slot.
     */
    public val slotName: kotlin.String? = builder.slotName
    /**
     * The unique identifier of the new slot type to associate with this slot.
     */
    public val slotTypeId: kotlin.String? = builder.slotTypeId
    /**
     * Specifications for the constituent sub slots and the expression for the composite slot.
     */
    public val subSlotSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting? = builder.subSlotSetting
    /**
     * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.
     */
    public val valueElicitationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting? = builder.valueElicitationSetting

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSlotRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("description=$description,")
        append("intentId=$intentId,")
        append("localeId=$localeId,")
        append("multipleValuesSetting=$multipleValuesSetting,")
        append("obfuscationSetting=$obfuscationSetting,")
        append("slotId=$slotId,")
        append("slotName=$slotName,")
        append("slotTypeId=$slotTypeId,")
        append("subSlotSetting=$subSlotSetting,")
        append("valueElicitationSetting=$valueElicitationSetting")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (intentId?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (multipleValuesSetting?.hashCode() ?: 0)
        result = 31 * result + (obfuscationSetting?.hashCode() ?: 0)
        result = 31 * result + (slotId?.hashCode() ?: 0)
        result = 31 * result + (slotName?.hashCode() ?: 0)
        result = 31 * result + (slotTypeId?.hashCode() ?: 0)
        result = 31 * result + (subSlotSetting?.hashCode() ?: 0)
        result = 31 * result + (valueElicitationSetting?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSlotRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (description != other.description) return false
        if (intentId != other.intentId) return false
        if (localeId != other.localeId) return false
        if (multipleValuesSetting != other.multipleValuesSetting) return false
        if (obfuscationSetting != other.obfuscationSetting) return false
        if (slotId != other.slotId) return false
        if (slotName != other.slotName) return false
        if (slotTypeId != other.slotTypeId) return false
        if (subSlotSetting != other.subSlotSetting) return false
        if (valueElicitationSetting != other.valueElicitationSetting) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the bot that contains the slot.
         */
        public var botId: kotlin.String? = null
        /**
         * The version of the bot that contains the slot. Must always be `DRAFT`.
         */
        public var botVersion: kotlin.String? = null
        /**
         * The new description for the slot.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the intent that contains the slot.
         */
        public var intentId: kotlin.String? = null
        /**
         * The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        public var localeId: kotlin.String? = null
        /**
         * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to `true` in any other locale, Amazon Lex throws a `ValidationException`.
         *
         * If the `multipleValuesSetting` is not set, the default value is `false`.
         */
        public var multipleValuesSetting: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting? = null
        /**
         * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
         */
        public var obfuscationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting? = null
        /**
         * The unique identifier for the slot to update.
         */
        public var slotId: kotlin.String? = null
        /**
         * The new name for the slot.
         */
        public var slotName: kotlin.String? = null
        /**
         * The unique identifier of the new slot type to associate with this slot.
         */
        public var slotTypeId: kotlin.String? = null
        /**
         * Specifications for the constituent sub slots and the expression for the composite slot.
         */
        public var subSlotSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting? = null
        /**
         * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.
         */
        public var valueElicitationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.description = x.description
            this.intentId = x.intentId
            this.localeId = x.localeId
            this.multipleValuesSetting = x.multipleValuesSetting
            this.obfuscationSetting = x.obfuscationSetting
            this.slotId = x.slotId
            this.slotName = x.slotName
            this.slotTypeId = x.slotTypeId
            this.subSlotSetting = x.subSlotSetting
            this.valueElicitationSetting = x.valueElicitationSetting
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest = UpdateSlotRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting] inside the given [block]
         */
        public fun multipleValuesSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting.Builder.() -> kotlin.Unit) {
            this.multipleValuesSetting = aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting] inside the given [block]
         */
        public fun obfuscationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting.Builder.() -> kotlin.Unit) {
            this.obfuscationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting] inside the given [block]
         */
        public fun subSlotSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting.Builder.() -> kotlin.Unit) {
            this.subSlotSetting = aws.sdk.kotlin.services.lexmodelsv2.model.SubSlotSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting] inside the given [block]
         */
        public fun valueElicitationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting.Builder.() -> kotlin.Unit) {
            this.valueElicitationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
