// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the test set that is imported.
 */
public class TestSetImportResourceSpecification private constructor(builder: Builder) {
    /**
     * The description of the test set.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Contains information about the input location from where test-set should be imported.
     */
    public val importInputLocation: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportInputLocation? = builder.importInputLocation
    /**
     * Specifies whether the test-set being imported contains written or spoken data.
     */
    public val modality: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetModality = requireNotNull(builder.modality) { "A non-null value must be provided for modality" }
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * Contains information about the location that Amazon Lex uses to store the test-set.
     */
    public val storageLocation: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation? = builder.storageLocation
    /**
     * The name of the test set.
     */
    public val testSetName: kotlin.String = requireNotNull(builder.testSetName) { "A non-null value must be provided for testSetName" }
    /**
     * A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You can't use the `UpdateTestSet` operation to update tags. To update tags, use the `TagResource` operation.
     */
    public val testSetTags: Map<String, String>? = builder.testSetTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportResourceSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestSetImportResourceSpecification(")
        append("description=$description,")
        append("importInputLocation=$importInputLocation,")
        append("modality=$modality,")
        append("roleArn=$roleArn,")
        append("storageLocation=$storageLocation,")
        append("testSetName=$testSetName,")
        append("testSetTags=$testSetTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (importInputLocation?.hashCode() ?: 0)
        result = 31 * result + (modality.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (storageLocation?.hashCode() ?: 0)
        result = 31 * result + (testSetName.hashCode())
        result = 31 * result + (testSetTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestSetImportResourceSpecification

        if (description != other.description) return false
        if (importInputLocation != other.importInputLocation) return false
        if (modality != other.modality) return false
        if (roleArn != other.roleArn) return false
        if (storageLocation != other.storageLocation) return false
        if (testSetName != other.testSetName) return false
        if (testSetTags != other.testSetTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportResourceSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the test set.
         */
        public var description: kotlin.String? = null
        /**
         * Contains information about the input location from where test-set should be imported.
         */
        public var importInputLocation: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportInputLocation? = null
        /**
         * Specifies whether the test-set being imported contains written or spoken data.
         */
        public var modality: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetModality? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permission to access the test set.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Contains information about the location that Amazon Lex uses to store the test-set.
         */
        public var storageLocation: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation? = null
        /**
         * The name of the test set.
         */
        public var testSetName: kotlin.String? = null
        /**
         * A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You can't use the `UpdateTestSet` operation to update tags. To update tags, use the `TagResource` operation.
         */
        public var testSetTags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportResourceSpecification) : this() {
            this.description = x.description
            this.importInputLocation = x.importInputLocation
            this.modality = x.modality
            this.roleArn = x.roleArn
            this.storageLocation = x.storageLocation
            this.testSetName = x.testSetName
            this.testSetTags = x.testSetTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportResourceSpecification = TestSetImportResourceSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportInputLocation] inside the given [block]
         */
        public fun importInputLocation(block: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportInputLocation.Builder.() -> kotlin.Unit) {
            this.importInputLocation = aws.sdk.kotlin.services.lexmodelsv2.model.TestSetImportInputLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation] inside the given [block]
         */
        public fun storageLocation(block: aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation.Builder.() -> kotlin.Unit) {
            this.storageLocation = aws.sdk.kotlin.services.lexmodelsv2.model.TestSetStorageLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (modality == null) modality = TestSetModality.SdkUnknown("no value provided")
            if (roleArn == null) roleArn = ""
            if (testSetName == null) testSetName = ""
            return this
        }
    }
}
