// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the messages that Amazon Lex sends to a user to remind them that the bot is waiting for a response.
 */
public class StillWaitingResponseSpecification private constructor(builder: Builder) {
    /**
     * Indicates that the user can interrupt the response by speaking while the message is being played.
     */
    public val allowInterrupt: kotlin.Boolean? = builder.allowInterrupt
    /**
     * How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.
     */
    public val frequencyInSeconds: kotlin.Int = requireNotNull(builder.frequencyInSeconds) { "A non-null value must be provided for frequencyInSeconds" }
    /**
     * One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex sends to the user.
     */
    public val messageGroups: List<MessageGroup> = requireNotNull(builder.messageGroups) { "A non-null value must be provided for messageGroups" }
    /**
     * If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
     */
    public val timeoutInSeconds: kotlin.Int = requireNotNull(builder.timeoutInSeconds) { "A non-null value must be provided for timeoutInSeconds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StillWaitingResponseSpecification(")
        append("allowInterrupt=$allowInterrupt,")
        append("frequencyInSeconds=$frequencyInSeconds,")
        append("messageGroups=$messageGroups,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowInterrupt?.hashCode() ?: 0
        result = 31 * result + (frequencyInSeconds)
        result = 31 * result + (messageGroups.hashCode())
        result = 31 * result + (timeoutInSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StillWaitingResponseSpecification

        if (allowInterrupt != other.allowInterrupt) return false
        if (frequencyInSeconds != other.frequencyInSeconds) return false
        if (messageGroups != other.messageGroups) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates that the user can interrupt the response by speaking while the message is being played.
         */
        public var allowInterrupt: kotlin.Boolean? = null
        /**
         * How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.
         */
        public var frequencyInSeconds: kotlin.Int? = null
        /**
         * One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex sends to the user.
         */
        public var messageGroups: List<MessageGroup>? = null
        /**
         * If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
         */
        public var timeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification) : this() {
            this.allowInterrupt = x.allowInterrupt
            this.frequencyInSeconds = x.frequencyInSeconds
            this.messageGroups = x.messageGroups
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification = StillWaitingResponseSpecification(this)

        internal fun correctErrors(): Builder {
            if (frequencyInSeconds == null) frequencyInSeconds = 0
            if (messageGroups == null) messageGroups = emptyList()
            if (timeoutInSeconds == null) timeoutInSeconds = 0
            return this
        }
    }
}
