// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies an Amazon S3 bucket for logging audio conversations
 */
public class S3BucketLogDestination private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The S3 prefix to assign to audio log files.
     */
    public val logPrefix: kotlin.String = requireNotNull(builder.logPrefix) { "A non-null value must be provided for logPrefix" }
    /**
     * The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
     */
    public val s3BucketArn: kotlin.String = requireNotNull(builder.s3BucketArn) { "A non-null value must be provided for s3BucketArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketLogDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketLogDestination(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("logPrefix=$logPrefix,")
        append("s3BucketArn=$s3BucketArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (logPrefix.hashCode())
        result = 31 * result + (s3BucketArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketLogDestination

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (logPrefix != other.logPrefix) return false
        if (s3BucketArn != other.s3BucketArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketLogDestination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The S3 prefix to assign to audio log files.
         */
        public var logPrefix: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
         */
        public var s3BucketArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketLogDestination) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.logPrefix = x.logPrefix
            this.s3BucketArn = x.s3BucketArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.S3BucketLogDestination = S3BucketLogDestination(this)

        internal fun correctErrors(): Builder {
            if (logPrefix == null) logPrefix = ""
            if (s3BucketArn == null) s3BucketArn = ""
            return this
        }
    }
}
