// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about the configuration of the Amazon Kendra index used for the `AMAZON.QnAIntent`.
 */
public class QnAKendraConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon Bedrock model you select generate a response based on the results. To use this feature, you must first add FAQ questions to your index by following the steps at [Adding frequently asked questions (FAQs) to an index](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html).
     */
    public val exactResponse: kotlin.Boolean = builder.exactResponse
    /**
     * The ARN of the Amazon Kendra index to use.
     */
    public val kendraIndex: kotlin.String = requireNotNull(builder.kendraIndex) { "A non-null value must be provided for kendraIndex" }
    /**
     * Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra search filter JSON format, see [Using document attributes to filter search results](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering).
     */
    public val queryFilterString: kotlin.String? = builder.queryFilterString
    /**
     * Specifies whether to enable an Amazon Kendra filter string or not.
     */
    public val queryFilterStringEnabled: kotlin.Boolean = builder.queryFilterStringEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QnAKendraConfiguration(")
        append("exactResponse=$exactResponse,")
        append("kendraIndex=$kendraIndex,")
        append("queryFilterString=$queryFilterString,")
        append("queryFilterStringEnabled=$queryFilterStringEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exactResponse.hashCode()
        result = 31 * result + (kendraIndex.hashCode())
        result = 31 * result + (queryFilterString?.hashCode() ?: 0)
        result = 31 * result + (queryFilterStringEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QnAKendraConfiguration

        if (exactResponse != other.exactResponse) return false
        if (kendraIndex != other.kendraIndex) return false
        if (queryFilterString != other.queryFilterString) return false
        if (queryFilterStringEnabled != other.queryFilterStringEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to return an exact response from the Amazon Kendra index or to let the Amazon Bedrock model you select generate a response based on the results. To use this feature, you must first add FAQ questions to your index by following the steps at [Adding frequently asked questions (FAQs) to an index](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html).
         */
        public var exactResponse: kotlin.Boolean = false
        /**
         * The ARN of the Amazon Kendra index to use.
         */
        public var kendraIndex: kotlin.String? = null
        /**
         * Contains the Amazon Kendra filter string to use if enabled. For more information on the Amazon Kendra search filter JSON format, see [Using document attributes to filter search results](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering).
         */
        public var queryFilterString: kotlin.String? = null
        /**
         * Specifies whether to enable an Amazon Kendra filter string or not.
         */
        public var queryFilterStringEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration) : this() {
            this.exactResponse = x.exactResponse
            this.kendraIndex = x.kendraIndex
            this.queryFilterString = x.queryFilterString
            this.queryFilterStringEnabled = x.queryFilterStringEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration = QnAKendraConfiguration(this)

        internal fun correctErrors(): Builder {
            if (kendraIndex == null) kendraIndex = ""
            return this
        }
    }
}
