// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about the configuration of the Amazon OpenSearch Service database used for the `AMAZON.QnAIntent`.
 */
public class OpensearchConfiguration private constructor(builder: Builder) {
    /**
     * The endpoint of the Amazon OpenSearch Service domain.
     */
    public val domainEndpoint: kotlin.String = requireNotNull(builder.domainEndpoint) { "A non-null value must be provided for domainEndpoint" }
    /**
     * Specifies whether to return an exact response or to return an answer generated by the model using the fields you specify from the database.
     */
    public val exactResponse: kotlin.Boolean = builder.exactResponse
    /**
     * Contains the names of the fields used for an exact response to the user.
     */
    public val exactResponseFields: aws.sdk.kotlin.services.lexmodelsv2.model.ExactResponseFields? = builder.exactResponseFields
    /**
     * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the query.
     */
    public val includeFields: List<String>? = builder.includeFields
    /**
     * The name of the Amazon OpenSearch Service index.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpensearchConfiguration(")
        append("domainEndpoint=$domainEndpoint,")
        append("exactResponse=$exactResponse,")
        append("exactResponseFields=$exactResponseFields,")
        append("includeFields=$includeFields,")
        append("indexName=$indexName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainEndpoint.hashCode()
        result = 31 * result + (exactResponse.hashCode())
        result = 31 * result + (exactResponseFields?.hashCode() ?: 0)
        result = 31 * result + (includeFields?.hashCode() ?: 0)
        result = 31 * result + (indexName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpensearchConfiguration

        if (domainEndpoint != other.domainEndpoint) return false
        if (exactResponse != other.exactResponse) return false
        if (exactResponseFields != other.exactResponseFields) return false
        if (includeFields != other.includeFields) return false
        if (indexName != other.indexName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The endpoint of the Amazon OpenSearch Service domain.
         */
        public var domainEndpoint: kotlin.String? = null
        /**
         * Specifies whether to return an exact response or to return an answer generated by the model using the fields you specify from the database.
         */
        public var exactResponse: kotlin.Boolean = false
        /**
         * Contains the names of the fields used for an exact response to the user.
         */
        public var exactResponseFields: aws.sdk.kotlin.services.lexmodelsv2.model.ExactResponseFields? = null
        /**
         * Contains a list of fields from the Amazon OpenSearch Service that the model can use to generate the answer to the query.
         */
        public var includeFields: List<String>? = null
        /**
         * The name of the Amazon OpenSearch Service index.
         */
        public var indexName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration) : this() {
            this.domainEndpoint = x.domainEndpoint
            this.exactResponse = x.exactResponse
            this.exactResponseFields = x.exactResponseFields
            this.includeFields = x.includeFields
            this.indexName = x.indexName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration = OpensearchConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ExactResponseFields] inside the given [block]
         */
        public fun exactResponseFields(block: aws.sdk.kotlin.services.lexmodelsv2.model.ExactResponseFields.Builder.() -> kotlin.Unit) {
            this.exactResponseFields = aws.sdk.kotlin.services.lexmodelsv2.model.ExactResponseFields.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainEndpoint == null) domainEndpoint = ""
            if (indexName == null) indexName = ""
            return this
        }
    }
}
