// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListUtteranceMetricsRequest private constructor(builder: Builder) {
    /**
     * A list containing attributes related to the utterance that you want the response to return. The following attributes are possible:
     * + `LastUsedIntent` – The last used intent at the time of the utterance.
     */
    public val attributes: List<AnalyticsUtteranceAttribute>? = builder.attributes
    /**
     * A list of objects, each of which contains specifications for organizing the results by time.
     */
    public val binBy: List<AnalyticsBinBySpecification>? = builder.binBy
    /**
     * The identifier for the bot for which you want to retrieve utterance metrics.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The date and time that marks the end of the range of time for which you want to see utterance metrics.
     */
    public val endDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endDateTime
    /**
     * A list of objects, each of which describes a condition by which you want to filter the results.
     */
    public val filters: List<AnalyticsUtteranceFilter>? = builder.filters
    /**
     * A list of objects, each of which specifies how to group the results. You can group by the following criteria:
     * + `UtteranceText` – The transcription of the utterance.
     * + `UtteranceState` – The state of the utterance. The possible states are detailed in [Key definitions](https://docs.aws.amazon.com/analytics-key-definitions-utterances) in the user guide.
     */
    public val groupBy: List<AnalyticsUtteranceGroupBySpecification>? = builder.groupBy
    /**
     * The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.
     */
    public val metrics: List<AnalyticsUtteranceMetric>? = builder.metrics
    /**
     * If the response from the ListUtteranceMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.
     *
     * Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next page of results. For a complete set of results, call the ListUtteranceMetrics operation until the nextToken returned in the response is null.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The date and time that marks the beginning of the range of time for which you want to see utterance metrics.
     */
    public val startDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListUtteranceMetricsRequest(")
        append("attributes=$attributes,")
        append("binBy=$binBy,")
        append("botId=$botId,")
        append("endDateTime=$endDateTime,")
        append("filters=$filters,")
        append("groupBy=$groupBy,")
        append("maxResults=$maxResults,")
        append("metrics=$metrics,")
        append("nextToken=$nextToken,")
        append("startDateTime=$startDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (binBy?.hashCode() ?: 0)
        result = 31 * result + (botId?.hashCode() ?: 0)
        result = 31 * result + (endDateTime?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (groupBy?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListUtteranceMetricsRequest

        if (attributes != other.attributes) return false
        if (binBy != other.binBy) return false
        if (botId != other.botId) return false
        if (endDateTime != other.endDateTime) return false
        if (filters != other.filters) return false
        if (groupBy != other.groupBy) return false
        if (maxResults != other.maxResults) return false
        if (metrics != other.metrics) return false
        if (nextToken != other.nextToken) return false
        if (startDateTime != other.startDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list containing attributes related to the utterance that you want the response to return. The following attributes are possible:
         * + `LastUsedIntent` – The last used intent at the time of the utterance.
         */
        public var attributes: List<AnalyticsUtteranceAttribute>? = null
        /**
         * A list of objects, each of which contains specifications for organizing the results by time.
         */
        public var binBy: List<AnalyticsBinBySpecification>? = null
        /**
         * The identifier for the bot for which you want to retrieve utterance metrics.
         */
        public var botId: kotlin.String? = null
        /**
         * The date and time that marks the end of the range of time for which you want to see utterance metrics.
         */
        public var endDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of objects, each of which describes a condition by which you want to filter the results.
         */
        public var filters: List<AnalyticsUtteranceFilter>? = null
        /**
         * A list of objects, each of which specifies how to group the results. You can group by the following criteria:
         * + `UtteranceText` – The transcription of the utterance.
         * + `UtteranceState` – The state of the utterance. The possible states are detailed in [Key definitions](https://docs.aws.amazon.com/analytics-key-definitions-utterances) in the user guide.
         */
        public var groupBy: List<AnalyticsUtteranceGroupBySpecification>? = null
        /**
         * The maximum number of results to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to return, and the method by which to organize the results.
         */
        public var metrics: List<AnalyticsUtteranceMetric>? = null
        /**
         * If the response from the ListUtteranceMetrics operation contains more results than specified in the maxResults parameter, a token is returned in the response.
         *
         * Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next page of results. For a complete set of results, call the ListUtteranceMetrics operation until the nextToken returned in the response is null.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The date and time that marks the beginning of the range of time for which you want to see utterance metrics.
         */
        public var startDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsRequest) : this() {
            this.attributes = x.attributes
            this.binBy = x.binBy
            this.botId = x.botId
            this.endDateTime = x.endDateTime
            this.filters = x.filters
            this.groupBy = x.groupBy
            this.maxResults = x.maxResults
            this.metrics = x.metrics
            this.nextToken = x.nextToken
            this.startDateTime = x.startDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.ListUtteranceMetricsRequest = ListUtteranceMetricsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
