// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides configuration information for the `AMAZON.KendraSearchIntent` intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
 */
public class KendraConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the `AMAZON.KendraSearchIntent` intent to search. The index must be in the same account and Region as the Amazon Lex bot.
     */
    public val kendraIndex: kotlin.String = requireNotNull(builder.kendraIndex) { "A non-null value must be provided for kendraIndex" }
    /**
     * A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see [Filtering queries](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
     */
    public val queryFilterString: kotlin.String? = builder.queryFilterString
    /**
     * Determines whether the `AMAZON.KendraSearchIntent` intent uses a custom query string to query the Amazon Kendra index.
     */
    public val queryFilterStringEnabled: kotlin.Boolean = builder.queryFilterStringEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KendraConfiguration(")
        append("kendraIndex=$kendraIndex,")
        append("queryFilterString=$queryFilterString,")
        append("queryFilterStringEnabled=$queryFilterStringEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kendraIndex.hashCode()
        result = 31 * result + (queryFilterString?.hashCode() ?: 0)
        result = 31 * result + (queryFilterStringEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KendraConfiguration

        if (kendraIndex != other.kendraIndex) return false
        if (queryFilterString != other.queryFilterString) return false
        if (queryFilterStringEnabled != other.queryFilterStringEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the `AMAZON.KendraSearchIntent` intent to search. The index must be in the same account and Region as the Amazon Lex bot.
         */
        public var kendraIndex: kotlin.String? = null
        /**
         * A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see [Filtering queries](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
         */
        public var queryFilterString: kotlin.String? = null
        /**
         * Determines whether the `AMAZON.KendraSearchIntent` intent uses a custom query string to query the Amazon Kendra index.
         */
        public var queryFilterStringEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration) : this() {
            this.kendraIndex = x.kendraIndex
            this.queryFilterString = x.queryFilterString
            this.queryFilterStringEnabled = x.queryFilterStringEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration = KendraConfiguration(this)

        internal fun correctErrors(): Builder {
            if (kendraIndex == null) kendraIndex = ""
            return this
        }
    }
}
