// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides a prompt for making sure that the user is ready for the intent to be fulfilled.
 */
public class IntentConfirmationSetting private constructor(builder: Builder) {
    /**
     * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the `active` field isn't specified, the default is true.
     */
    public val active: kotlin.Boolean? = builder.active
    /**
     * The `DialogCodeHookInvocationSetting` object associated with intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `InvokeDialogCodeHook`.
     */
    public val codeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting? = builder.codeHook
    /**
     * A list of conditional branches to evaluate after the intent is closed.
     */
    public val confirmationConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = builder.confirmationConditional
    /**
     * Specifies the next step that the bot executes when the customer confirms the intent.
     */
    public val confirmationNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = builder.confirmationNextStep
    /**
     * Specifies a list of message groups that Amazon Lex uses to respond the user input.
     */
    public val confirmationResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.confirmationResponse
    /**
     * A list of conditional branches to evaluate after the intent is declined.
     */
    public val declinationConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = builder.declinationConditional
    /**
     * Specifies the next step that the bot executes when the customer declines the intent.
     */
    public val declinationNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = builder.declinationNextStep
    /**
     * When the user answers "no" to the question defined in `promptSpecification`, Amazon Lex responds with this response to acknowledge that the intent was canceled.
     */
    public val declinationResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.declinationResponse
    /**
     * The `DialogCodeHookInvocationSetting` used when the code hook is invoked during confirmation prompt retries.
     */
    public val elicitationCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting? = builder.elicitationCodeHook
    /**
     * Provides a list of conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
     */
    public val failureConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = builder.failureConditional
    /**
     * The next step to take in the conversation if the confirmation step fails.
     */
    public val failureNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = builder.failureNextStep
    /**
     * Specifies a list of message groups that Amazon Lex uses to respond the user input.
     */
    public val failureResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.failureResponse
    /**
     * Prompts the user to confirm the intent. This question should have a yes or no answer.
     *
     * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the `OrderPizza` intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
     */
    public val promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = builder.promptSpecification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntentConfirmationSetting(")
        append("active=$active,")
        append("codeHook=$codeHook,")
        append("confirmationConditional=$confirmationConditional,")
        append("confirmationNextStep=$confirmationNextStep,")
        append("confirmationResponse=$confirmationResponse,")
        append("declinationConditional=$declinationConditional,")
        append("declinationNextStep=$declinationNextStep,")
        append("declinationResponse=$declinationResponse,")
        append("elicitationCodeHook=$elicitationCodeHook,")
        append("failureConditional=$failureConditional,")
        append("failureNextStep=$failureNextStep,")
        append("failureResponse=$failureResponse,")
        append("promptSpecification=$promptSpecification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (codeHook?.hashCode() ?: 0)
        result = 31 * result + (confirmationConditional?.hashCode() ?: 0)
        result = 31 * result + (confirmationNextStep?.hashCode() ?: 0)
        result = 31 * result + (confirmationResponse?.hashCode() ?: 0)
        result = 31 * result + (declinationConditional?.hashCode() ?: 0)
        result = 31 * result + (declinationNextStep?.hashCode() ?: 0)
        result = 31 * result + (declinationResponse?.hashCode() ?: 0)
        result = 31 * result + (elicitationCodeHook?.hashCode() ?: 0)
        result = 31 * result + (failureConditional?.hashCode() ?: 0)
        result = 31 * result + (failureNextStep?.hashCode() ?: 0)
        result = 31 * result + (failureResponse?.hashCode() ?: 0)
        result = 31 * result + (promptSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntentConfirmationSetting

        if (active != other.active) return false
        if (codeHook != other.codeHook) return false
        if (confirmationConditional != other.confirmationConditional) return false
        if (confirmationNextStep != other.confirmationNextStep) return false
        if (confirmationResponse != other.confirmationResponse) return false
        if (declinationConditional != other.declinationConditional) return false
        if (declinationNextStep != other.declinationNextStep) return false
        if (declinationResponse != other.declinationResponse) return false
        if (elicitationCodeHook != other.elicitationCodeHook) return false
        if (failureConditional != other.failureConditional) return false
        if (failureNextStep != other.failureNextStep) return false
        if (failureResponse != other.failureResponse) return false
        if (promptSpecification != other.promptSpecification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the `active` field isn't specified, the default is true.
         */
        public var active: kotlin.Boolean? = null
        /**
         * The `DialogCodeHookInvocationSetting` object associated with intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `InvokeDialogCodeHook`.
         */
        public var codeHook: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting? = null
        /**
         * A list of conditional branches to evaluate after the intent is closed.
         */
        public var confirmationConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = null
        /**
         * Specifies the next step that the bot executes when the customer confirms the intent.
         */
        public var confirmationNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = null
        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         */
        public var confirmationResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * A list of conditional branches to evaluate after the intent is declined.
         */
        public var declinationConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = null
        /**
         * Specifies the next step that the bot executes when the customer declines the intent.
         */
        public var declinationNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = null
        /**
         * When the user answers "no" to the question defined in `promptSpecification`, Amazon Lex responds with this response to acknowledge that the intent was canceled.
         */
        public var declinationResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * The `DialogCodeHookInvocationSetting` used when the code hook is invoked during confirmation prompt retries.
         */
        public var elicitationCodeHook: aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting? = null
        /**
         * Provides a list of conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition.
         */
        public var failureConditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = null
        /**
         * The next step to take in the conversation if the confirmation step fails.
         */
        public var failureNextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = null
        /**
         * Specifies a list of message groups that Amazon Lex uses to respond the user input.
         */
        public var failureResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         *
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the `OrderPizza` intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information.
         */
        public var promptSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting) : this() {
            this.active = x.active
            this.codeHook = x.codeHook
            this.confirmationConditional = x.confirmationConditional
            this.confirmationNextStep = x.confirmationNextStep
            this.confirmationResponse = x.confirmationResponse
            this.declinationConditional = x.declinationConditional
            this.declinationNextStep = x.declinationNextStep
            this.declinationResponse = x.declinationResponse
            this.elicitationCodeHook = x.elicitationCodeHook
            this.failureConditional = x.failureConditional
            this.failureNextStep = x.failureNextStep
            this.failureResponse = x.failureResponse
            this.promptSpecification = x.promptSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting = IntentConfirmationSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting] inside the given [block]
         */
        public fun codeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting.Builder.() -> kotlin.Unit) {
            this.codeHook = aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification] inside the given [block]
         */
        public fun confirmationConditional(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.Builder.() -> kotlin.Unit) {
            this.confirmationConditional = aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogState] inside the given [block]
         */
        public fun confirmationNextStep(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.Builder.() -> kotlin.Unit) {
            this.confirmationNextStep = aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        public fun confirmationResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.confirmationResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification] inside the given [block]
         */
        public fun declinationConditional(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.Builder.() -> kotlin.Unit) {
            this.declinationConditional = aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogState] inside the given [block]
         */
        public fun declinationNextStep(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.Builder.() -> kotlin.Unit) {
            this.declinationNextStep = aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        public fun declinationResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.declinationResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting] inside the given [block]
         */
        public fun elicitationCodeHook(block: aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.Builder.() -> kotlin.Unit) {
            this.elicitationCodeHook = aws.sdk.kotlin.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification] inside the given [block]
         */
        public fun failureConditional(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.Builder.() -> kotlin.Unit) {
            this.failureConditional = aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogState] inside the given [block]
         */
        public fun failureNextStep(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.Builder.() -> kotlin.Unit) {
            this.failureNextStep = aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        public fun failureResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.failureResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification] inside the given [block]
         */
        public fun promptSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.Builder.() -> kotlin.Unit) {
            this.promptSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.PromptSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
