// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides a statement the Amazon Lex conveys to the user when the intent is successfully fulfilled.
 */
public class IntentClosingSetting private constructor(builder: Builder) {
    /**
     * Specifies whether an intent's closing response is used. When this field is false, the closing response isn't sent to the user. If the `active` field isn't specified, the default is true.
     */
    public val active: kotlin.Boolean? = builder.active
    /**
     * The response that Amazon Lex sends to the user when the intent is complete.
     */
    public val closingResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.closingResponse
    /**
     * A list of conditional branches associated with the intent's closing response. These branches are executed when the `nextStep` attribute is set to `EvalutateConditional`.
     */
    public val conditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = builder.conditional
    /**
     * Specifies the next step that the bot executes after playing the intent's closing response.
     */
    public val nextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = builder.nextStep

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntentClosingSetting(")
        append("active=$active,")
        append("closingResponse=$closingResponse,")
        append("conditional=$conditional,")
        append("nextStep=$nextStep")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (closingResponse?.hashCode() ?: 0)
        result = 31 * result + (conditional?.hashCode() ?: 0)
        result = 31 * result + (nextStep?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntentClosingSetting

        if (active != other.active) return false
        if (closingResponse != other.closingResponse) return false
        if (conditional != other.conditional) return false
        if (nextStep != other.nextStep) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether an intent's closing response is used. When this field is false, the closing response isn't sent to the user. If the `active` field isn't specified, the default is true.
         */
        public var active: kotlin.Boolean? = null
        /**
         * The response that Amazon Lex sends to the user when the intent is complete.
         */
        public var closingResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * A list of conditional branches associated with the intent's closing response. These branches are executed when the `nextStep` attribute is set to `EvalutateConditional`.
         */
        public var conditional: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification? = null
        /**
         * Specifies the next step that the bot executes after playing the intent's closing response.
         */
        public var nextStep: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting) : this() {
            this.active = x.active
            this.closingResponse = x.closingResponse
            this.conditional = x.conditional
            this.nextStep = x.nextStep
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting = IntentClosingSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        public fun closingResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.closingResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification] inside the given [block]
         */
        public fun conditional(block: aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.Builder.() -> kotlin.Unit) {
            this.conditional = aws.sdk.kotlin.services.lexmodelsv2.model.ConditionalSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DialogState] inside the given [block]
         */
        public fun nextStep(block: aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.Builder.() -> kotlin.Unit) {
            this.nextStep = aws.sdk.kotlin.services.lexmodelsv2.model.DialogState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
