// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.
 */
public class FulfillmentUpdateResponseSpecification private constructor(builder: Builder) {
    /**
     * Determines whether the user can interrupt an update message while it is playing.
     */
    public val allowInterrupt: kotlin.Boolean? = builder.allowInterrupt
    /**
     * The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
     */
    public val frequencyInSeconds: kotlin.Int = requireNotNull(builder.frequencyInSeconds) { "A non-null value must be provided for frequencyInSeconds" }
    /**
     * 1 - 5 message groups that contain update messages. Amazon Lex chooses one of the messages to play to the user.
     */
    public val messageGroups: List<MessageGroup> = requireNotNull(builder.messageGroups) { "A non-null value must be provided for messageGroups" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FulfillmentUpdateResponseSpecification(")
        append("allowInterrupt=$allowInterrupt,")
        append("frequencyInSeconds=$frequencyInSeconds,")
        append("messageGroups=$messageGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowInterrupt?.hashCode() ?: 0
        result = 31 * result + (frequencyInSeconds)
        result = 31 * result + (messageGroups.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FulfillmentUpdateResponseSpecification

        if (allowInterrupt != other.allowInterrupt) return false
        if (frequencyInSeconds != other.frequencyInSeconds) return false
        if (messageGroups != other.messageGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines whether the user can interrupt an update message while it is playing.
         */
        public var allowInterrupt: kotlin.Boolean? = null
        /**
         * The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
         */
        public var frequencyInSeconds: kotlin.Int? = null
        /**
         * 1 - 5 message groups that contain update messages. Amazon Lex chooses one of the messages to play to the user.
         */
        public var messageGroups: List<MessageGroup>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification) : this() {
            this.allowInterrupt = x.allowInterrupt
            this.frequencyInSeconds = x.frequencyInSeconds
            this.messageGroups = x.messageGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentUpdateResponseSpecification = FulfillmentUpdateResponseSpecification(this)

        internal fun correctErrors(): Builder {
            if (frequencyInSeconds == null) frequencyInSeconds = 0
            if (messageGroups == null) messageGroups = emptyList()
            return this
        }
    }
}
