// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
 */
public class FulfillmentStartResponseSpecification private constructor(builder: Builder) {
    /**
     * Determines whether the user can interrupt the start message while it is playing.
     */
    public val allowInterrupt: kotlin.Boolean? = builder.allowInterrupt
    /**
     * The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
     */
    public val delayInSeconds: kotlin.Int = requireNotNull(builder.delayInSeconds) { "A non-null value must be provided for delayInSeconds" }
    /**
     * 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.
     */
    public val messageGroups: List<MessageGroup> = requireNotNull(builder.messageGroups) { "A non-null value must be provided for messageGroups" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FulfillmentStartResponseSpecification(")
        append("allowInterrupt=$allowInterrupt,")
        append("delayInSeconds=$delayInSeconds,")
        append("messageGroups=$messageGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowInterrupt?.hashCode() ?: 0
        result = 31 * result + (delayInSeconds)
        result = 31 * result + (messageGroups.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FulfillmentStartResponseSpecification

        if (allowInterrupt != other.allowInterrupt) return false
        if (delayInSeconds != other.delayInSeconds) return false
        if (messageGroups != other.messageGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines whether the user can interrupt the start message while it is playing.
         */
        public var allowInterrupt: kotlin.Boolean? = null
        /**
         * The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
         */
        public var delayInSeconds: kotlin.Int? = null
        /**
         * 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user.
         */
        public var messageGroups: List<MessageGroup>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification) : this() {
            this.allowInterrupt = x.allowInterrupt
            this.delayInSeconds = x.delayInSeconds
            this.messageGroups = x.messageGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentStartResponseSpecification = FulfillmentStartResponseSpecification(this)

        internal fun correctErrors(): Builder {
            if (delayInSeconds == null) delayInSeconds = 0
            if (messageGroups == null) messageGroups = emptyList()
            return this
        }
    }
}
