// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the DTMF input specifications.
 */
public class DtmfSpecification private constructor(builder: Builder) {
    /**
     * The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
     */
    public val deletionCharacter: kotlin.String = requireNotNull(builder.deletionCharacter) { "A non-null value must be provided for deletionCharacter" }
    /**
     * The DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
     */
    public val endCharacter: kotlin.String = requireNotNull(builder.endCharacter) { "A non-null value must be provided for endCharacter" }
    /**
     * How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
     */
    public val endTimeoutMs: kotlin.Int = requireNotNull(builder.endTimeoutMs) { "A non-null value must be provided for endTimeoutMs" }
    /**
     * The maximum number of DTMF digits allowed in an utterance.
     */
    public val maxLength: kotlin.Int = requireNotNull(builder.maxLength) { "A non-null value must be provided for maxLength" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.DtmfSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DtmfSpecification(")
        append("deletionCharacter=$deletionCharacter,")
        append("endCharacter=$endCharacter,")
        append("endTimeoutMs=$endTimeoutMs,")
        append("maxLength=$maxLength")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionCharacter.hashCode()
        result = 31 * result + (endCharacter.hashCode())
        result = 31 * result + (endTimeoutMs)
        result = 31 * result + (maxLength)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DtmfSpecification

        if (deletionCharacter != other.deletionCharacter) return false
        if (endCharacter != other.endCharacter) return false
        if (endTimeoutMs != other.endTimeoutMs) return false
        if (maxLength != other.maxLength) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.DtmfSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The DTMF character that clears the accumulated DTMF digits and immediately ends the input.
         */
        public var deletionCharacter: kotlin.String? = null
        /**
         * The DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
         */
        public var endCharacter: kotlin.String? = null
        /**
         * How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
         */
        public var endTimeoutMs: kotlin.Int? = null
        /**
         * The maximum number of DTMF digits allowed in an utterance.
         */
        public var maxLength: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.DtmfSpecification) : this() {
            this.deletionCharacter = x.deletionCharacter
            this.endCharacter = x.endCharacter
            this.endTimeoutMs = x.endTimeoutMs
            this.maxLength = x.maxLength
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.DtmfSpecification = DtmfSpecification(this)

        internal fun correctErrors(): Builder {
            if (deletionCharacter == null) deletionCharacter = ""
            if (endCharacter == null) endCharacter = ""
            if (endTimeoutMs == null) endTimeoutMs = 0
            if (maxLength == null) maxLength = 0
            return this
        }
    }
}
