// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings that specify the dialog code hook that is called by Amazon Lex at a step of the conversation.
 */
public class DialogCodeHookInvocationSetting private constructor(builder: Builder) {
    /**
     * Determines whether a dialog code hook is used when the intent is activated.
     */
    public val active: kotlin.Boolean = requireNotNull(builder.active) { "A non-null value must be provided for active" }
    /**
     * Indicates whether a Lambda function should be invoked for the dialog.
     */
    public val enableCodeHookInvocation: kotlin.Boolean = requireNotNull(builder.enableCodeHookInvocation) { "A non-null value must be provided for enableCodeHookInvocation" }
    /**
     * A label that indicates the dialog step from which the dialog code hook is happening.
     */
    public val invocationLabel: kotlin.String? = builder.invocationLabel
    /**
     * Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
     */
    public val postCodeHookSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification? = builder.postCodeHookSpecification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DialogCodeHookInvocationSetting(")
        append("active=$active,")
        append("enableCodeHookInvocation=$enableCodeHookInvocation,")
        append("invocationLabel=$invocationLabel,")
        append("postCodeHookSpecification=$postCodeHookSpecification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active.hashCode()
        result = 31 * result + (enableCodeHookInvocation.hashCode())
        result = 31 * result + (invocationLabel?.hashCode() ?: 0)
        result = 31 * result + (postCodeHookSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DialogCodeHookInvocationSetting

        if (active != other.active) return false
        if (enableCodeHookInvocation != other.enableCodeHookInvocation) return false
        if (invocationLabel != other.invocationLabel) return false
        if (postCodeHookSpecification != other.postCodeHookSpecification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines whether a dialog code hook is used when the intent is activated.
         */
        public var active: kotlin.Boolean? = null
        /**
         * Indicates whether a Lambda function should be invoked for the dialog.
         */
        public var enableCodeHookInvocation: kotlin.Boolean? = null
        /**
         * A label that indicates the dialog step from which the dialog code hook is happening.
         */
        public var invocationLabel: kotlin.String? = null
        /**
         * Contains the responses and actions that Amazon Lex takes after the Lambda function is complete.
         */
        public var postCodeHookSpecification: aws.sdk.kotlin.services.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting) : this() {
            this.active = x.active
            this.enableCodeHookInvocation = x.enableCodeHookInvocation
            this.invocationLabel = x.invocationLabel
            this.postCodeHookSpecification = x.postCodeHookSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookInvocationSetting = DialogCodeHookInvocationSetting(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification] inside the given [block]
         */
        public fun postCodeHookSpecification(block: aws.sdk.kotlin.services.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification.Builder.() -> kotlin.Unit) {
            this.postCodeHookSpecification = aws.sdk.kotlin.services.lexmodelsv2.model.PostDialogCodeHookInvocationSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (active == null) active = false
            if (enableCodeHookInvocation == null) enableCodeHookInvocation = false
            return this
        }
    }
}
