// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains details about the configuration of the knowledge store used for the `AMAZON.QnAIntent`. You must have already created the knowledge store and indexed the documents within it.
 */
public class DataSourceConfiguration private constructor(builder: Builder) {
    /**
     * Contains details about the configuration of the Amazon Bedrock knowledge base used for the `AMAZON.QnAIntent`. To set up a knowledge base, follow the steps at [Building a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html).
     */
    public val bedrockKnowledgeStoreConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.BedrockKnowledgeStoreConfiguration? = builder.bedrockKnowledgeStoreConfiguration
    /**
     * Contains details about the configuration of the Amazon Kendra index used for the `AMAZON.QnAIntent`. To create a Amazon Kendra index, follow the steps at [Creating an index](https://docs.aws.amazon.com/kendra/latest/dg/create-index.html).
     */
    public val kendraConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration? = builder.kendraConfiguration
    /**
     * Contains details about the configuration of the Amazon OpenSearch Service database used for the `AMAZON.QnAIntent`. To create a domain, follow the steps at [Creating and managing Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
     */
    public val opensearchConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration? = builder.opensearchConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.DataSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceConfiguration(")
        append("bedrockKnowledgeStoreConfiguration=$bedrockKnowledgeStoreConfiguration,")
        append("kendraConfiguration=$kendraConfiguration,")
        append("opensearchConfiguration=$opensearchConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bedrockKnowledgeStoreConfiguration?.hashCode() ?: 0
        result = 31 * result + (kendraConfiguration?.hashCode() ?: 0)
        result = 31 * result + (opensearchConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceConfiguration

        if (bedrockKnowledgeStoreConfiguration != other.bedrockKnowledgeStoreConfiguration) return false
        if (kendraConfiguration != other.kendraConfiguration) return false
        if (opensearchConfiguration != other.opensearchConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.DataSourceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains details about the configuration of the Amazon Bedrock knowledge base used for the `AMAZON.QnAIntent`. To set up a knowledge base, follow the steps at [Building a knowledge base](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html).
         */
        public var bedrockKnowledgeStoreConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.BedrockKnowledgeStoreConfiguration? = null
        /**
         * Contains details about the configuration of the Amazon Kendra index used for the `AMAZON.QnAIntent`. To create a Amazon Kendra index, follow the steps at [Creating an index](https://docs.aws.amazon.com/kendra/latest/dg/create-index.html).
         */
        public var kendraConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration? = null
        /**
         * Contains details about the configuration of the Amazon OpenSearch Service database used for the `AMAZON.QnAIntent`. To create a domain, follow the steps at [Creating and managing Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
         */
        public var opensearchConfiguration: aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.DataSourceConfiguration) : this() {
            this.bedrockKnowledgeStoreConfiguration = x.bedrockKnowledgeStoreConfiguration
            this.kendraConfiguration = x.kendraConfiguration
            this.opensearchConfiguration = x.opensearchConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.DataSourceConfiguration = DataSourceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.BedrockKnowledgeStoreConfiguration] inside the given [block]
         */
        public fun bedrockKnowledgeStoreConfiguration(block: aws.sdk.kotlin.services.lexmodelsv2.model.BedrockKnowledgeStoreConfiguration.Builder.() -> kotlin.Unit) {
            this.bedrockKnowledgeStoreConfiguration = aws.sdk.kotlin.services.lexmodelsv2.model.BedrockKnowledgeStoreConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration] inside the given [block]
         */
        public fun kendraConfiguration(block: aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration.Builder.() -> kotlin.Unit) {
            this.kendraConfiguration = aws.sdk.kotlin.services.lexmodelsv2.model.QnAKendraConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration] inside the given [block]
         */
        public fun opensearchConfiguration(block: aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration.Builder.() -> kotlin.Unit) {
            this.opensearchConfiguration = aws.sdk.kotlin.services.lexmodelsv2.model.OpensearchConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
