// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSlotTypeRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bot associated with this slot type.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The identifier of the bot version associated with this slot type.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * Specifications for a composite slot type.
     */
    public val compositeSlotTypeSetting: aws.sdk.kotlin.services.lexmodelsv2.model.CompositeSlotTypeSetting? = builder.compositeSlotTypeSetting
    /**
     * A description of the slot type. Use the description to help identify the slot type in lists.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Sets the type of external information used to create the slot type.
     */
    public val externalSourceSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting? = builder.externalSourceSetting
    /**
     * The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    public val localeId: kotlin.String? = builder.localeId
    /**
     * The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.
     *
     * Only `AMAZON.AlphaNumeric` is supported.
     */
    public val parentSlotTypeSignature: kotlin.String? = builder.parentSlotTypeSignature
    /**
     * The name for the slot. A slot type name must be unique within the intent.
     */
    public val slotTypeName: kotlin.String? = builder.slotTypeName
    /**
     * A list of `SlotTypeValue` objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
     */
    public val slotTypeValues: List<SlotTypeValue>? = builder.slotTypeValues
    /**
     * Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:
     * + `ORIGINAL_VALUE` - Returns the value entered by the user, if the user value is similar to the slot value.
     * + `TOP_RESOLUTION` - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.
     *
     * If you don't specify the `valueSelectionSetting` parameter, the default is `ORIGINAL_VALUE`.
     */
    public val valueSelectionSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting? = builder.valueSelectionSetting

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSlotTypeRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("compositeSlotTypeSetting=$compositeSlotTypeSetting,")
        append("description=$description,")
        append("externalSourceSetting=$externalSourceSetting,")
        append("localeId=$localeId,")
        append("parentSlotTypeSignature=$parentSlotTypeSignature,")
        append("slotTypeName=$slotTypeName,")
        append("slotTypeValues=$slotTypeValues,")
        append("valueSelectionSetting=$valueSelectionSetting")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (compositeSlotTypeSetting?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (externalSourceSetting?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (parentSlotTypeSignature?.hashCode() ?: 0)
        result = 31 * result + (slotTypeName?.hashCode() ?: 0)
        result = 31 * result + (slotTypeValues?.hashCode() ?: 0)
        result = 31 * result + (valueSelectionSetting?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSlotTypeRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (compositeSlotTypeSetting != other.compositeSlotTypeSetting) return false
        if (description != other.description) return false
        if (externalSourceSetting != other.externalSourceSetting) return false
        if (localeId != other.localeId) return false
        if (parentSlotTypeSignature != other.parentSlotTypeSignature) return false
        if (slotTypeName != other.slotTypeName) return false
        if (slotTypeValues != other.slotTypeValues) return false
        if (valueSelectionSetting != other.valueSelectionSetting) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the bot associated with this slot type.
         */
        public var botId: kotlin.String? = null
        /**
         * The identifier of the bot version associated with this slot type.
         */
        public var botVersion: kotlin.String? = null
        /**
         * Specifications for a composite slot type.
         */
        public var compositeSlotTypeSetting: aws.sdk.kotlin.services.lexmodelsv2.model.CompositeSlotTypeSetting? = null
        /**
         * A description of the slot type. Use the description to help identify the slot type in lists.
         */
        public var description: kotlin.String? = null
        /**
         * Sets the type of external information used to create the slot type.
         */
        public var externalSourceSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting? = null
        /**
         * The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        public var localeId: kotlin.String? = null
        /**
         * The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.
         *
         * Only `AMAZON.AlphaNumeric` is supported.
         */
        public var parentSlotTypeSignature: kotlin.String? = null
        /**
         * The name for the slot. A slot type name must be unique within the intent.
         */
        public var slotTypeName: kotlin.String? = null
        /**
         * A list of `SlotTypeValue` objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
         */
        public var slotTypeValues: List<SlotTypeValue>? = null
        /**
         * Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:
         * + `ORIGINAL_VALUE` - Returns the value entered by the user, if the user value is similar to the slot value.
         * + `TOP_RESOLUTION` - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.
         *
         * If you don't specify the `valueSelectionSetting` parameter, the default is `ORIGINAL_VALUE`.
         */
        public var valueSelectionSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.compositeSlotTypeSetting = x.compositeSlotTypeSetting
            this.description = x.description
            this.externalSourceSetting = x.externalSourceSetting
            this.localeId = x.localeId
            this.parentSlotTypeSignature = x.parentSlotTypeSignature
            this.slotTypeName = x.slotTypeName
            this.slotTypeValues = x.slotTypeValues
            this.valueSelectionSetting = x.valueSelectionSetting
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateSlotTypeRequest = CreateSlotTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.CompositeSlotTypeSetting] inside the given [block]
         */
        public fun compositeSlotTypeSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.CompositeSlotTypeSetting.Builder.() -> kotlin.Unit) {
            this.compositeSlotTypeSetting = aws.sdk.kotlin.services.lexmodelsv2.model.CompositeSlotTypeSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting] inside the given [block]
         */
        public fun externalSourceSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting.Builder.() -> kotlin.Unit) {
            this.externalSourceSetting = aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting] inside the given [block]
         */
        public fun valueSelectionSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting.Builder.() -> kotlin.Unit) {
            this.valueSelectionSetting = aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
