// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateBotResponse private constructor(builder: Builder) {
    /**
     * A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.
     */
    public val botId: kotlin.String? = builder.botId
    /**
     * The list of bots in a network that was created.
     */
    public val botMembers: List<BotMember>? = builder.botMembers
    /**
     * The name specified for the bot.
     */
    public val botName: kotlin.String? = builder.botName
    /**
     * Shows the current status of the bot. The bot is first in the `Creating` status. Once the bot is read for use, it changes to the `Available` status. After the bot is created, you can use the `DRAFT` version of the bot.
     */
    public val botStatus: aws.sdk.kotlin.services.lexmodelsv2.model.BotStatus? = builder.botStatus
    /**
     * A list of tags associated with the bot.
     */
    public val botTags: Map<String, String>? = builder.botTags
    /**
     * The type of a bot that was created.
     */
    public val botType: aws.sdk.kotlin.services.lexmodelsv2.model.BotType? = builder.botType
    /**
     * A timestamp indicating the date and time that the bot was created.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The data privacy settings specified for the bot.
     */
    public val dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = builder.dataPrivacy
    /**
     * The description specified for the bot.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies configuration settings for delivering error logs to Cloudwatch Logs in an Amazon Lex bot response.
     */
    public val errorLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings? = builder.errorLogSettings
    /**
     * The session idle time specified for the bot.
     */
    public val idleSessionTtlInSeconds: kotlin.Int? = builder.idleSessionTtlInSeconds
    /**
     * The IAM role specified for the bot.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of tags associated with the test alias for the bot.
     */
    public val testBotAliasTags: Map<String, String>? = builder.testBotAliasTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBotResponse(")
        append("botId=$botId,")
        append("botMembers=$botMembers,")
        append("botName=$botName,")
        append("botStatus=$botStatus,")
        append("botTags=$botTags,")
        append("botType=$botType,")
        append("creationDateTime=$creationDateTime,")
        append("dataPrivacy=$dataPrivacy,")
        append("description=$description,")
        append("errorLogSettings=$errorLogSettings,")
        append("idleSessionTtlInSeconds=$idleSessionTtlInSeconds,")
        append("roleArn=$roleArn,")
        append("testBotAliasTags=$testBotAliasTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botMembers?.hashCode() ?: 0)
        result = 31 * result + (botName?.hashCode() ?: 0)
        result = 31 * result + (botStatus?.hashCode() ?: 0)
        result = 31 * result + (botTags?.hashCode() ?: 0)
        result = 31 * result + (botType?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (dataPrivacy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorLogSettings?.hashCode() ?: 0)
        result = 31 * result + (idleSessionTtlInSeconds ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (testBotAliasTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBotResponse

        if (botId != other.botId) return false
        if (botMembers != other.botMembers) return false
        if (botName != other.botName) return false
        if (botStatus != other.botStatus) return false
        if (botTags != other.botTags) return false
        if (botType != other.botType) return false
        if (creationDateTime != other.creationDateTime) return false
        if (dataPrivacy != other.dataPrivacy) return false
        if (description != other.description) return false
        if (errorLogSettings != other.errorLogSettings) return false
        if (idleSessionTtlInSeconds != other.idleSessionTtlInSeconds) return false
        if (roleArn != other.roleArn) return false
        if (testBotAliasTags != other.testBotAliasTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.
         */
        public var botId: kotlin.String? = null
        /**
         * The list of bots in a network that was created.
         */
        public var botMembers: List<BotMember>? = null
        /**
         * The name specified for the bot.
         */
        public var botName: kotlin.String? = null
        /**
         * Shows the current status of the bot. The bot is first in the `Creating` status. Once the bot is read for use, it changes to the `Available` status. After the bot is created, you can use the `DRAFT` version of the bot.
         */
        public var botStatus: aws.sdk.kotlin.services.lexmodelsv2.model.BotStatus? = null
        /**
         * A list of tags associated with the bot.
         */
        public var botTags: Map<String, String>? = null
        /**
         * The type of a bot that was created.
         */
        public var botType: aws.sdk.kotlin.services.lexmodelsv2.model.BotType? = null
        /**
         * A timestamp indicating the date and time that the bot was created.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data privacy settings specified for the bot.
         */
        public var dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = null
        /**
         * The description specified for the bot.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies configuration settings for delivering error logs to Cloudwatch Logs in an Amazon Lex bot response.
         */
        public var errorLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings? = null
        /**
         * The session idle time specified for the bot.
         */
        public var idleSessionTtlInSeconds: kotlin.Int? = null
        /**
         * The IAM role specified for the bot.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of tags associated with the test alias for the bot.
         */
        public var testBotAliasTags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotResponse) : this() {
            this.botId = x.botId
            this.botMembers = x.botMembers
            this.botName = x.botName
            this.botStatus = x.botStatus
            this.botTags = x.botTags
            this.botType = x.botType
            this.creationDateTime = x.creationDateTime
            this.dataPrivacy = x.dataPrivacy
            this.description = x.description
            this.errorLogSettings = x.errorLogSettings
            this.idleSessionTtlInSeconds = x.idleSessionTtlInSeconds
            this.roleArn = x.roleArn
            this.testBotAliasTags = x.testBotAliasTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotResponse = CreateBotResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy] inside the given [block]
         */
        public fun dataPrivacy(block: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.Builder.() -> kotlin.Unit) {
            this.dataPrivacy = aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings] inside the given [block]
         */
        public fun errorLogSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings.Builder.() -> kotlin.Unit) {
            this.errorLogSettings = aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
