// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateBotRequest private constructor(builder: Builder) {
    /**
     * The list of bot members in a network to be created.
     */
    public val botMembers: List<BotMember>? = builder.botMembers
    /**
     * The name of the bot. The bot name must be unique in the account that creates the bot.
     */
    public val botName: kotlin.String? = builder.botName
    /**
     * A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the `UpdateBot` operation to update tags. To update tags, use the `TagResource` operation.
     */
    public val botTags: Map<String, String>? = builder.botTags
    /**
     * The type of a bot to create.
     */
    public val botType: aws.sdk.kotlin.services.lexmodelsv2.model.BotType? = builder.botType
    /**
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    public val dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = builder.dataPrivacy
    /**
     * A description of the bot. It appears in lists to help you identify a particular bot.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the configuration for error logging during bot creation.
     */
    public val errorLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings? = builder.errorLogSettings
    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     *
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public val idleSessionTtlInSeconds: kotlin.Int? = builder.idleSessionTtlInSeconds
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the `UpdateAlias` operation to update tags. To update tags on the test alias, use the `TagResource` operation.
     */
    public val testBotAliasTags: Map<String, String>? = builder.testBotAliasTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBotRequest(")
        append("botMembers=$botMembers,")
        append("botName=$botName,")
        append("botTags=$botTags,")
        append("botType=$botType,")
        append("dataPrivacy=$dataPrivacy,")
        append("description=$description,")
        append("errorLogSettings=$errorLogSettings,")
        append("idleSessionTtlInSeconds=$idleSessionTtlInSeconds,")
        append("roleArn=$roleArn,")
        append("testBotAliasTags=$testBotAliasTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botMembers?.hashCode() ?: 0
        result = 31 * result + (botName?.hashCode() ?: 0)
        result = 31 * result + (botTags?.hashCode() ?: 0)
        result = 31 * result + (botType?.hashCode() ?: 0)
        result = 31 * result + (dataPrivacy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorLogSettings?.hashCode() ?: 0)
        result = 31 * result + (idleSessionTtlInSeconds ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (testBotAliasTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBotRequest

        if (botMembers != other.botMembers) return false
        if (botName != other.botName) return false
        if (botTags != other.botTags) return false
        if (botType != other.botType) return false
        if (dataPrivacy != other.dataPrivacy) return false
        if (description != other.description) return false
        if (errorLogSettings != other.errorLogSettings) return false
        if (idleSessionTtlInSeconds != other.idleSessionTtlInSeconds) return false
        if (roleArn != other.roleArn) return false
        if (testBotAliasTags != other.testBotAliasTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of bot members in a network to be created.
         */
        public var botMembers: List<BotMember>? = null
        /**
         * The name of the bot. The bot name must be unique in the account that creates the bot.
         */
        public var botName: kotlin.String? = null
        /**
         * A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the `UpdateBot` operation to update tags. To update tags, use the `TagResource` operation.
         */
        public var botTags: Map<String, String>? = null
        /**
         * The type of a bot to create.
         */
        public var botType: aws.sdk.kotlin.services.lexmodelsv2.model.BotType? = null
        /**
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         */
        public var dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = null
        /**
         * A description of the bot. It appears in lists to help you identify a particular bot.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the configuration for error logging during bot creation.
         */
        public var errorLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings? = null
        /**
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         *
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         */
        public var idleSessionTtlInSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the `UpdateAlias` operation to update tags. To update tags on the test alias, use the `TagResource` operation.
         */
        public var testBotAliasTags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotRequest) : this() {
            this.botMembers = x.botMembers
            this.botName = x.botName
            this.botTags = x.botTags
            this.botType = x.botType
            this.dataPrivacy = x.dataPrivacy
            this.description = x.description
            this.errorLogSettings = x.errorLogSettings
            this.idleSessionTtlInSeconds = x.idleSessionTtlInSeconds
            this.roleArn = x.roleArn
            this.testBotAliasTags = x.testBotAliasTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotRequest = CreateBotRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy] inside the given [block]
         */
        public fun dataPrivacy(block: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.Builder.() -> kotlin.Unit) {
            this.dataPrivacy = aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings] inside the given [block]
         */
        public fun errorLogSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings.Builder.() -> kotlin.Unit) {
            this.errorLogSettings = aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
