// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the bot parameters required for importing a bot.
 */
public class BotImportSpecification private constructor(builder: Builder) {
    /**
     * The name that Amazon Lex should use for the bot.
     */
    public val botName: kotlin.String = requireNotNull(builder.botName) { "A non-null value must be provided for botName" }
    /**
     * A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the `UpdateBot` operation to update tags. To update tags, use the `TagResource` operation.
     */
    public val botTags: Map<String, String>? = builder.botTags
    /**
     * By default, data stored by Amazon Lex is encrypted. The `DataPrivacy` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.
     */
    public val dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = builder.dataPrivacy
    /**
     * Allows you to configure destinations where error logs will be published during the bot import process.
     */
    public val errorLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings? = builder.errorLogSettings
    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     *
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public val idleSessionTtlInSeconds: kotlin.Int? = builder.idleSessionTtlInSeconds
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use the `UpdateAlias` operation to update tags. To update tags on the test alias, use the `TagResource` operation.
     */
    public val testBotAliasTags: Map<String, String>? = builder.testBotAliasTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BotImportSpecification(")
        append("botName=$botName,")
        append("botTags=$botTags,")
        append("dataPrivacy=$dataPrivacy,")
        append("errorLogSettings=$errorLogSettings,")
        append("idleSessionTtlInSeconds=$idleSessionTtlInSeconds,")
        append("roleArn=$roleArn,")
        append("testBotAliasTags=$testBotAliasTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = botName.hashCode()
        result = 31 * result + (botTags?.hashCode() ?: 0)
        result = 31 * result + (dataPrivacy?.hashCode() ?: 0)
        result = 31 * result + (errorLogSettings?.hashCode() ?: 0)
        result = 31 * result + (idleSessionTtlInSeconds ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (testBotAliasTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BotImportSpecification

        if (botName != other.botName) return false
        if (botTags != other.botTags) return false
        if (dataPrivacy != other.dataPrivacy) return false
        if (errorLogSettings != other.errorLogSettings) return false
        if (idleSessionTtlInSeconds != other.idleSessionTtlInSeconds) return false
        if (roleArn != other.roleArn) return false
        if (testBotAliasTags != other.testBotAliasTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name that Amazon Lex should use for the bot.
         */
        public var botName: kotlin.String? = null
        /**
         * A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the `UpdateBot` operation to update tags. To update tags, use the `TagResource` operation.
         */
        public var botTags: Map<String, String>? = null
        /**
         * By default, data stored by Amazon Lex is encrypted. The `DataPrivacy` structure provides settings that determine how Amazon Lex handles special cases of securing the data for your bot.
         */
        public var dataPrivacy: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy? = null
        /**
         * Allows you to configure destinations where error logs will be published during the bot import process.
         */
        public var errorLogSettings: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings? = null
        /**
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         *
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         */
        public var idleSessionTtlInSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use the `UpdateAlias` operation to update tags. To update tags on the test alias, use the `TagResource` operation.
         */
        public var testBotAliasTags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification) : this() {
            this.botName = x.botName
            this.botTags = x.botTags
            this.dataPrivacy = x.dataPrivacy
            this.errorLogSettings = x.errorLogSettings
            this.idleSessionTtlInSeconds = x.idleSessionTtlInSeconds
            this.roleArn = x.roleArn
            this.testBotAliasTags = x.testBotAliasTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.BotImportSpecification = BotImportSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy] inside the given [block]
         */
        public fun dataPrivacy(block: aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.Builder.() -> kotlin.Unit) {
            this.dataPrivacy = aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings] inside the given [block]
         */
        public fun errorLogSettings(block: aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings.Builder.() -> kotlin.Unit) {
            this.errorLogSettings = aws.sdk.kotlin.services.lexmodelsv2.model.ErrorLogSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (botName == null) botName = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
