// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information for aggregated utterances. The `ListAggregatedUtterances` operations combines all instances of the same utterance into a single aggregated summary.
 */
public class AggregatedUtterancesSummary private constructor(builder: Builder) {
    /**
     * Aggregated utterance data may contain utterances from versions of your bot that have since been deleted. When the aggregated contains this kind of data, this field is set to true.
     */
    public val containsDataFromDeletedResources: kotlin.Boolean? = builder.containsDataFromDeletedResources
    /**
     * The number of times that the utterance was detected by Amazon Lex during the time period. When an utterance is detected, it activates an intent or a slot.
     */
    public val hitCount: kotlin.Int? = builder.hitCount
    /**
     * The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn't activate an intent or slot.
     */
    public val missedCount: kotlin.Int? = builder.missedCount
    /**
     * The text of the utterance. If the utterance was used with the `RecognizeUtterance` operation, the text is the transcription of the audio utterance.
     */
    public val utterance: kotlin.String? = builder.utterance
    /**
     * The date and time that the utterance was first recorded in the time window for aggregation. An utterance may have been sent to Amazon Lex before that time, but only utterances within the time window are counted.
     */
    public val utteranceFirstRecordedInAggregationDuration: aws.smithy.kotlin.runtime.time.Instant? = builder.utteranceFirstRecordedInAggregationDuration
    /**
     * The last date and time that an utterance was recorded in the time window for aggregation. An utterance may be sent to Amazon Lex after that time, but only utterances within the time window are counted.
     */
    public val utteranceLastRecordedInAggregationDuration: aws.smithy.kotlin.runtime.time.Instant? = builder.utteranceLastRecordedInAggregationDuration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.AggregatedUtterancesSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AggregatedUtterancesSummary(")
        append("containsDataFromDeletedResources=$containsDataFromDeletedResources,")
        append("hitCount=$hitCount,")
        append("missedCount=$missedCount,")
        append("utterance=$utterance,")
        append("utteranceFirstRecordedInAggregationDuration=$utteranceFirstRecordedInAggregationDuration,")
        append("utteranceLastRecordedInAggregationDuration=$utteranceLastRecordedInAggregationDuration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containsDataFromDeletedResources?.hashCode() ?: 0
        result = 31 * result + (hitCount ?: 0)
        result = 31 * result + (missedCount ?: 0)
        result = 31 * result + (utterance?.hashCode() ?: 0)
        result = 31 * result + (utteranceFirstRecordedInAggregationDuration?.hashCode() ?: 0)
        result = 31 * result + (utteranceLastRecordedInAggregationDuration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AggregatedUtterancesSummary

        if (containsDataFromDeletedResources != other.containsDataFromDeletedResources) return false
        if (hitCount != other.hitCount) return false
        if (missedCount != other.missedCount) return false
        if (utterance != other.utterance) return false
        if (utteranceFirstRecordedInAggregationDuration != other.utteranceFirstRecordedInAggregationDuration) return false
        if (utteranceLastRecordedInAggregationDuration != other.utteranceLastRecordedInAggregationDuration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.AggregatedUtterancesSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Aggregated utterance data may contain utterances from versions of your bot that have since been deleted. When the aggregated contains this kind of data, this field is set to true.
         */
        public var containsDataFromDeletedResources: kotlin.Boolean? = null
        /**
         * The number of times that the utterance was detected by Amazon Lex during the time period. When an utterance is detected, it activates an intent or a slot.
         */
        public var hitCount: kotlin.Int? = null
        /**
         * The number of times that the utterance was missed by Amazon Lex An utterance is missed when it doesn't activate an intent or slot.
         */
        public var missedCount: kotlin.Int? = null
        /**
         * The text of the utterance. If the utterance was used with the `RecognizeUtterance` operation, the text is the transcription of the audio utterance.
         */
        public var utterance: kotlin.String? = null
        /**
         * The date and time that the utterance was first recorded in the time window for aggregation. An utterance may have been sent to Amazon Lex before that time, but only utterances within the time window are counted.
         */
        public var utteranceFirstRecordedInAggregationDuration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date and time that an utterance was recorded in the time window for aggregation. An utterance may be sent to Amazon Lex after that time, but only utterances within the time window are counted.
         */
        public var utteranceLastRecordedInAggregationDuration: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.AggregatedUtterancesSummary) : this() {
            this.containsDataFromDeletedResources = x.containsDataFromDeletedResources
            this.hitCount = x.hitCount
            this.missedCount = x.missedCount
            this.utterance = x.utterance
            this.utteranceFirstRecordedInAggregationDuration = x.utteranceFirstRecordedInAggregationDuration
            this.utteranceLastRecordedInAggregationDuration = x.utteranceLastRecordedInAggregationDuration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.AggregatedUtterancesSummary = AggregatedUtterancesSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
