// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.serde

import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.StartTestExecutionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.TestExecutionApiMode
import aws.sdk.kotlin.services.lexmodelsv2.model.TestExecutionModality
import aws.sdk.kotlin.services.lexmodelsv2.model.TestExecutionTarget
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class StartTestExecutionOperationDeserializer: HttpDeserialize<StartTestExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartTestExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartTestExecutionError(context, call)
        }
        val builder = StartTestExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartTestExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartTestExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartTestExecutionOperationBody(builder: StartTestExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("apiMode"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("target"))
    val TESTEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testExecutionId"))
    val TESTEXECUTIONMODALITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("testExecutionModality"))
    val TESTSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testSetId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIMODE_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
        field(TESTEXECUTIONID_DESCRIPTOR)
        field(TESTEXECUTIONMODALITY_DESCRIPTOR)
        field(TESTSETID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIMODE_DESCRIPTOR.index -> builder.apiMode = deserializeString().let { TestExecutionApiMode.fromValue(it) }
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TARGET_DESCRIPTOR.index -> builder.target = deserializeTestExecutionTargetDocument(deserializer)
                TESTEXECUTIONID_DESCRIPTOR.index -> builder.testExecutionId = deserializeString()
                TESTEXECUTIONMODALITY_DESCRIPTOR.index -> builder.testExecutionModality = deserializeString().let { TestExecutionModality.fromValue(it) }
                TESTSETID_DESCRIPTOR.index -> builder.testSetId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
